#ifndef _GLMAP_H
#define _GLMAP_H

#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library
#include <gl\glut.h>
#include <gl\glaux.h>

#include "glsnow.h"
#include "glcolorpalette.h"

#define PI 3.1415926535897932384626433832795
#define PIdiv180 (PI/180.0)

float roofAmbient[4] = {0.19225, 0.19225, 0.19225, 1.0};
float roofDiffuse[4] = {0.50754, 0.50754, 0.50754, 1.0};
float roofSpecular[4] = {0.508273, 0.508273, 0.508273, 1.0};
float roofEmission[4] = {0.0, 0.0, 0.0, 0.0};
float roofShine[1] = {51.2};

class CFunMap
{
public: 
	CFunMap()
	{
		polySubdivisions = 6;
		length = 15;
		size = 1;
	}

	void DrawTree(float x, float y)
	{
		float treeSmallHeight = 0.3;
		float treeLeavesRadius = 0.15;
		float treeBarkRadius = 0.1;
		float treeLeavesHeight = 0.3;
		float treeLeavesOffsetX = 0.09;
		float treeLeavesOffsetZ = 0.1;
		float treeLeavesVarianceZ = 0.05;
		float treeLeavesVarianceAngle = 8.0;

		float treeGreen1[4] = {0.23, 0.68, 0.28, 0};
		float treeGreen2[4] = {0.21, 0.58, 0.26, 0};
		float treeGreen3[4] = {0.14, 0.39, 0.18, 0};
		float treeGreen4[4] = {0.17, 0.45, 0.20, 0};
		float lightBrown[4] = {180, 120, 25};

		// Bottom & Top of tree
		glPushMatrix();
		glTranslatef(x, y, 0.0);

		glPushMatrix();
		glTranslatef(0.0, 0.0, treeSmallHeight);
		glPushMatrix();
		glColor4f(treeGreen3[0], treeGreen3[1], treeGreen3[2], treeGreen3[3]);
		glRotatef(30 + treeLeavesVarianceAngle * 0.2, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX, 0.0, treeLeavesVarianceZ * 0.2);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPushMatrix();
		glColor4f(treeGreen1[0], treeGreen1[1], treeGreen1[2], treeGreen1[3]);
		glRotatef(170 + treeLeavesVarianceAngle * 0.3, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX, 0.0, treeLeavesVarianceZ * 0.5);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPushMatrix();
		glColor4f(treeGreen4[0], treeGreen4[1], treeGreen4[2], treeGreen4[3]);
		glRotatef(260 + treeLeavesVarianceAngle * 0.1, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX, 0.0, treeLeavesVarianceZ * 0.2);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPopMatrix();

		glPushMatrix();
		glTranslatef(0.0, 0.0, treeSmallHeight + treeLeavesHeight);
		glPushMatrix();
		glColor4f(treeGreen1[0], treeGreen1[1], treeGreen1[2], treeGreen1[3]);
		glRotatef(90 + treeLeavesVarianceAngle * 0.6, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX, 0.0, treeLeavesVarianceZ * 0.7);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPushMatrix();
		glColor4f(treeGreen2[0], treeGreen2[1], treeGreen2[2], treeGreen2[3]);
		glRotatef(180 + treeLeavesVarianceAngle * 0.3, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX, 0.0, treeLeavesVarianceZ * 0.4);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPushMatrix();
		glColor4f(treeGreen3[0], treeGreen3[1], treeGreen3[2], treeGreen3[3]);
		glRotatef(270 + treeLeavesVarianceAngle * 0.4, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX, 0.0, treeLeavesVarianceZ * 0.2);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPopMatrix();

		glPushMatrix();
		glTranslatef(0.0, 0.0, treeSmallHeight + treeLeavesHeight - treeLeavesOffsetZ);
		glPushMatrix();
		glColor4f(treeGreen2[0], treeGreen2[1], treeGreen2[2], treeGreen2[3]);
		glRotatef(10 + treeLeavesVarianceAngle * 0.1, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX * 2, 0.0, treeLeavesVarianceZ * 0.3);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPushMatrix();
		glColor4f(treeGreen4[0], treeGreen4[1], treeGreen4[2], treeGreen4[3]);
		glRotatef(80 + treeLeavesVarianceAngle * 0.8, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX * 2, 0.0, treeLeavesVarianceZ * 0.7);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPushMatrix();
		glColor4f(treeGreen3[0], treeGreen3[1], treeGreen3[2], treeGreen3[3]);
		glRotatef(170 + treeLeavesVarianceAngle * 0.5, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX * 2, 0.0, treeLeavesVarianceZ * 0.9);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPopMatrix();

		glPushMatrix();
		glTranslatef(0.0, 0.0, treeSmallHeight + 2 * treeLeavesOffsetZ);
		glPushMatrix();
		glColor4f(treeGreen1[0], treeGreen1[1], treeGreen1[2], treeGreen1[3]);
		glRotatef(100 + treeLeavesVarianceAngle * 0.8, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX * 2.2, 0.0, treeLeavesVarianceZ * 0.2);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPushMatrix();
		glColor4f(treeGreen3[0], treeGreen3[1], treeGreen3[2], treeGreen3[3]);
		glRotatef(240 + treeLeavesVarianceAngle * 0.4, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX * 2.2, 0.0, treeLeavesVarianceZ * 0.3);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPushMatrix();
		glColor4f(treeGreen4[0], treeGreen4[1], treeGreen4[2], treeGreen4[3]);
		glRotatef(350 + treeLeavesVarianceAngle * 0.2, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX * 2.2, 0.0, treeLeavesVarianceZ * 0.5);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPopMatrix();

		glPushMatrix();
		glTranslatef(0.0, 0.0, treeSmallHeight + treeLeavesHeight - 2 * treeLeavesOffsetZ);
		glPushMatrix();
		glColor4f(treeGreen2[0], treeGreen2[1], treeGreen2[2], treeGreen2[3]);
		glRotatef(25 + treeLeavesVarianceAngle * 0.3, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX * 2, 0.0, treeLeavesVarianceZ * 0.7);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPushMatrix();
		glColor4f(treeGreen4[0], treeGreen4[1], treeGreen4[2], treeGreen4[3]);
		glRotatef(150 + treeLeavesVarianceAngle * 0.9, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX * 2, 0.0, treeLeavesVarianceZ * 0.9);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPushMatrix();
		glColor4f(treeGreen3[0], treeGreen3[1], treeGreen3[2], treeGreen3[3]);
		glRotatef(300 + treeLeavesVarianceAngle * 0.2, 0.0, 0.0, 1.0); 
		glTranslatef(treeLeavesOffsetX * 2, 0.0, treeLeavesVarianceZ * 0.5);
		glutSolidSphere(treeLeavesRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		glPopMatrix();

		glPushMatrix();
		glColor3ub(lightBrown[0], lightBrown[1], lightBrown[2]);
		gluCylinder(gluNewQuadric(), treeBarkRadius, treeBarkRadius, treeSmallHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPopMatrix();

	}

	void gluPlane(float width, float height, float color[])
	{
		glColor4ub(color[0], color[1], color[2], color[3]);
		glBegin(GL_QUADS);

		glNormal3f(0, -1, 0);
		glVertex3f(-width/2, 0, 0);
		glNormal3f(0, -1, 0);
		glVertex3f(width/2, 0, 0);
		glNormal3f(0, -1, 0);
		glVertex3f(width/2, 0, height);
		glNormal3f(0, -1, 0);
		glVertex3f(-width/2, 0, height);

		glEnd();
	}

	void gluMyCylinder(float x, float y, float z, float radius, float height, float gap, float color[], float subdivisions, float rz)
	{
		double degree = 3.14 * 2 / subdivisions;
		double theta = 0;
		double rCosTheta = radius;
		double rSinTheta = 0;
		double nextRSinTheta;
		double nextRCosTheta; 

		glColor3ub(color[0], color[1], color[2]);

		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glTranslatef(x, y, z);
		glRotatef(rz, 0, 0, 1);

		for (int i = 1; i < (subdivisions - gap + 1); i++)
		{
			theta += degree;
			nextRCosTheta = radius * cos(theta);
			nextRSinTheta = radius * sin(theta);
			
			// Top
			glBegin(GL_TRIANGLES);
				glNormal3f(0, 0, 1);
				glVertex3f(0, 0, height);
				glNormal3f(0, 0, 1);
				glVertex3f(rCosTheta, rSinTheta, height);
				glNormal3f(0, 0, 1);
				glVertex3f(nextRCosTheta, nextRSinTheta, height);
			glEnd();

			// Bottom
			glBegin(GL_TRIANGLES);
				glNormal3f(0, 0, -1);
				glVertex3f(0, 0, 0);
				glNormal3f(0, 0, -1);
				glVertex3f(rCosTheta, rSinTheta, 0);
				glNormal3f(0, 0, -1);
				glVertex3f(nextRCosTheta, nextRSinTheta, 0);
			glEnd();
		
			// Side
			glBegin(GL_QUADS);
				glNormal3f((radius * cos(theta - degree)), (radius * sin(theta - degree)), 0);
				glVertex3f(rCosTheta, rSinTheta, 0);
				glNormal3f(nextRCosTheta, nextRSinTheta, 0);
				glVertex3f(nextRCosTheta, nextRSinTheta, 0);
				glNormal3f(nextRCosTheta, nextRSinTheta, 0);
				glVertex3f(nextRCosTheta, nextRSinTheta, height);
				glNormal3f((radius * cos(theta - degree)), (radius * sin(theta - degree)), 0);
				glVertex3f(rCosTheta, rSinTheta, height);
			glEnd();

			rCosTheta = nextRCosTheta;
			rSinTheta = nextRSinTheta;
		}

		glPopMatrix();	
	}

	void gluRoundBox(float x, float y, float z, float width, float length, float height, float radius, float color[])
	{
		glColor3ub(color[0], color[1], color[2]);
		
		glPushMatrix();

		glTranslatef(x, y, z);
		
		glBegin(GL_QUADS);

		// Top
		glNormal3f(0, 0, 1);
		glVertex3f(-width/2, -length/2 - radius, height);
		glNormal3f(0, 0, 1);
		glVertex3f(width/2, -length/2 - radius, height);
		glNormal3f(0, 0, 1);
		glVertex3f(width/2, length/2 + radius, height);
		glNormal3f(0, 0, 1);
		glVertex3f(-width/2, length/2 + radius, height);

		// Bottom
		glNormal3f(0, 0, -1);
		glVertex3f(-width/2 - radius, -length/2, 0);
		glNormal3f(0, 0, -1);
		glVertex3f(width/2 + radius, -length/2, 0);
		glNormal3f(0, 0, -1);
		glVertex3f(width/2 + radius, length/2, 0);
		glNormal3f(0, 0, -1);
		glVertex3f(-width/2 - radius, length/2, 0);
		
		// Top2
		glNormal3f(0, 0, 1);
		glVertex3f(-width/2 - radius, -length/2, height);
		glNormal3f(0, 0, 1);
		glVertex3f(width/2 + radius, -length/2, height);
		glNormal3f(0, 0, 1);
		glVertex3f(width/2 + radius, length/2, height);
		glNormal3f(0, 0, 1);
		glVertex3f(-width/2 - radius, length/2, height);
			
		// Bottom2
		glNormal3f(0, 0, -1);
		glVertex3f(-width/2, -length/2 - radius, 0);
		glNormal3f(0, 0, -1);
		glVertex3f(width/2, -length/2 - radius, 0);
		glNormal3f(0, 0, -1);
		glVertex3f(width/2, length/2 + radius, 0);
		glNormal3f(0, 0, -1);
		glVertex3f(-width/2, length/2 + radius, 0);

		// Side facing front
		glNormal3f(0, -1, 0);
		glVertex3f(-width/2, -length/2 - radius, 0);
		glNormal3f(0, -1, 0);
		glVertex3f(width/2, -length/2 - radius, 0);
		glNormal3f(0, -1, 0);
		glVertex3f(width/2, -length/2 - radius, height);
		glNormal3f(0, -1, 0);
		glVertex3f(-width/2, -length/2 - radius, height);

		// Side facing back
		glNormal3f(0, 1, 0);
		glVertex3f(-width/2, length/2 + radius, 0);
		glNormal3f(0, 1, 0);
		glVertex3f(width/2, length/2 + radius, 0);
		glNormal3f(0, 1, 0);
		glVertex3f(width/2, length/2 + radius, height);
		glNormal3f(0, 1, 0);
		glVertex3f(-width/2, length/2 + radius, height);

		// Side facing right
		glNormal3f(-1, 0, 0);
		glVertex3f(-width/2 - radius, length/2, 0);
		glNormal3f(-1, 0, 0);
		glVertex3f(-width/2 - radius, -length/2, 0);
		glNormal3f(-1, 0, 0);
		glVertex3f(-width/2 - radius, -length/2, height);
		glNormal3f(-1, 0, 0);
		glVertex3f(-width/2 - radius, length/2, height);

		// Side facing left
		glNormal3f(1, 0, 0);
		glVertex3f(width/2 + radius, length/2, 0);
		glNormal3f(1, 0, 0);
		glVertex3f(width/2 + radius, -length/2, 0);
		glNormal3f(1, 0, 0);
		glVertex3f(width/2 + radius, -length/2, height);
		glNormal3f(1, 0, 0);
		glVertex3f(width/2 + radius, length/2, height);

		glEnd();

		glPopMatrix();

		// Corner cylinders
		gluMyCylinder(x-width/2, y-length/2, 0, radius, height, 0, color, polySubdivisions, 0);
		gluMyCylinder(x+width/2, y+length/2, 0, radius, height, 0, color, polySubdivisions, 0);
		gluMyCylinder(x-width/2, y+length/2, 0, radius, height, 0, color, polySubdivisions, 0);
		gluMyCylinder(x+width/2, y-length/2, 0, radius, height, 0, color, polySubdivisions, 0);

	}

	void DrawCylinderHouse(float x, float y)
	{
		float radiusHouse = 0.4;
		float heightHouse = 0.3;
		float radiusRoof = 0.45;
		float heightRoof = 0.4;
		float windowColor[4];
		windowColor[0] = purple[0];
		windowColor[1] = purple[1];
		windowColor[2] = purple[2];
		windowColor[3] = 85;

		glPushMatrix();

		glMaterialfv(GL_FRONT, GL_AMBIENT, roofAmbient);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, roofDiffuse);
		glMaterialfv(GL_FRONT, GL_SPECULAR, roofSpecular);
		glMaterialfv(GL_FRONT, GL_EMISSION, roofEmission);
		glMaterialfv(GL_FRONT, GL_SHININESS, roofShine);

		gluMyCylinder(x, y, 0,radiusHouse, heightHouse/3, 0, white, 2*polySubdivisions, -90 + (360/(2*polySubdivisions)));
		gluMyCylinder(x, y, heightHouse/3 - 0.01, radiusHouse, heightHouse/3 + 0.01, 2, white, 2*polySubdivisions, -90 + (360/(2*polySubdivisions)));
		gluMyCylinder(x, y, 2*heightHouse/3 - 0.01, radiusHouse, heightHouse/3 + 0.01, 0, white, 2*polySubdivisions, -90 + (360/(2*polySubdivisions)));

		glMaterialfv(GL_FRONT, GL_AMBIENT, defaultAmbient);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, defaultDiffuse);
		glMaterialfv(GL_FRONT, GL_SPECULAR, defaultSpecular);
		glMaterialfv(GL_FRONT, GL_EMISSION, defaultEmission);
		glMaterialfv(GL_FRONT, GL_SHININESS, defaultShine);

		glPopMatrix();

		glPushMatrix();
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_BLEND);
		glEnable(GL_BLEND);
		glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glTranslatef(x, y - (radiusHouse*0.95*sqrt(3)/2), heightHouse/3);
		gluPlane(radiusHouse*0.95, heightHouse/3, windowColor);
		glDisable(GL_BLEND);
		glPopMatrix();

		glPushMatrix();
		glColor3ub(red[0], red[1], red[2]);
		glTranslatef(x, y, heightHouse);
		glMaterialfv(GL_FRONT, GL_AMBIENT, roofAmbient);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, roofDiffuse);
		glMaterialfv(GL_FRONT, GL_SPECULAR, roofSpecular);
		glMaterialfv(GL_FRONT, GL_EMISSION, roofEmission);
		glMaterialfv(GL_FRONT, GL_SHININESS, roofShine);

		gluCylinder(gluNewQuadric(), radiusRoof, 0, heightRoof, 2*polySubdivisions, 2*polySubdivisions);

		glMaterialfv(GL_FRONT, GL_AMBIENT, defaultAmbient);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, defaultDiffuse);
		glMaterialfv(GL_FRONT, GL_SPECULAR, defaultSpecular);
		glMaterialfv(GL_FRONT, GL_EMISSION, defaultEmission);
		glMaterialfv(GL_FRONT, GL_SHININESS, defaultShine);

		glPopMatrix();
	}

	void DrawBoxHouse(float x, float y)
	{
		float widthHouse = 0.5;
		float lengthHouse = 0.5;
		float heightHouse = 0.3;
		float radiusCorner = 0.1;
		float heightRoof = 0.4;
		float offsetRoof = 0.02;
		float tiltRoofTriangle = 30;
		float tiltRoofQuad = 90 - atan((sin((90 - tiltRoofTriangle)*PIdiv180)*heightRoof)/((widthHouse + radiusCorner * 2)/2 + offsetRoof)) / PIdiv180;


		float heightQuad = sqrt((sin((90 - tiltRoofTriangle)*PIdiv180)*heightRoof) * (sin((90 - tiltRoofTriangle)*PIdiv180)*heightRoof) + ((widthHouse/2 + radiusCorner) + offsetRoof) * ((widthHouse/2 + radiusCorner) + offsetRoof));
		float offsetQuad = cos((90 - tiltRoofTriangle)*PIdiv180) * heightRoof;

		gluRoundBox(x, y, 0, widthHouse, lengthHouse, heightHouse, radiusCorner, white);

		glColor3ub(red[0], red[1], red[2]);

		glPushMatrix();

		glMaterialfv(GL_FRONT, GL_AMBIENT, roofAmbient);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, roofDiffuse);
		glMaterialfv(GL_FRONT, GL_SPECULAR, roofSpecular);
		glMaterialfv(GL_FRONT, GL_EMISSION, roofEmission);
		glMaterialfv(GL_FRONT, GL_SHININESS, roofShine);

		glTranslatef(x, y - (lengthHouse + radiusCorner * 2)/2 - offsetRoof, heightHouse);
		glRotatef(-tiltRoofTriangle, 1, 0, 0);
		glBegin(GL_TRIANGLES);

		glNormal3f(0, -1, 0);
		glVertex3f(-(widthHouse + radiusCorner * 2)/2 - offsetRoof, 0, 0);
		glNormal3f(0, -1, 0);
		glVertex3f((widthHouse + radiusCorner * 2)/2 + offsetRoof, 0, 0);
		glNormal3f(0, -1, 0);
		glVertex3f(0, 0, heightRoof);
		
		glEnd();

		glMaterialfv(GL_FRONT, GL_AMBIENT, defaultAmbient);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, defaultDiffuse);
		glMaterialfv(GL_FRONT, GL_SPECULAR, defaultSpecular);
		glMaterialfv(GL_FRONT, GL_EMISSION, defaultEmission);
		glMaterialfv(GL_FRONT, GL_SHININESS, defaultShine);

		glPopMatrix();

		glPushMatrix();
		glTranslatef(x, y + (lengthHouse + radiusCorner * 2)/2 + offsetRoof, heightHouse);
		glRotatef(tiltRoofTriangle, 1, 0, 0);
		glBegin(GL_TRIANGLES);

		glNormal3f(0, 1, 0);
		glVertex3f(-(widthHouse + radiusCorner * 2)/2 - offsetRoof, 0, 0);
		glNormal3f(0, 1, 0);
		glVertex3f((widthHouse + radiusCorner * 2)/2 + offsetRoof, 0, 0);
		glNormal3f(0, 1, 0);
		glVertex3f(0, 0, heightRoof);
		
		glEnd();
		glPopMatrix();

		glPushMatrix();
		glTranslatef(x - (widthHouse/2 + radiusCorner) - offsetRoof, y, heightHouse);
		glRotatef(tiltRoofQuad, 0, 1, 0);
		glBegin(GL_QUADS);

		glNormal3f(-1, 0, 0);
		glVertex3f(0, (lengthHouse + radiusCorner * 2)/2 + offsetRoof, 0);
		glNormal3f(-1, 0, 0);
		glVertex3f(0, -(lengthHouse + radiusCorner * 2)/2 - offsetRoof, 0);
		glNormal3f(-1, 0, 0);
		glVertex3f(0, -(lengthHouse + radiusCorner * 2)/2 - offsetRoof + offsetQuad, heightQuad);
		glNormal3f(-1, 0, 0);
		glVertex3f(0, (lengthHouse + radiusCorner * 2)/2 + offsetRoof - offsetQuad, heightQuad);
		
		glEnd();
		glPopMatrix();

		glPushMatrix();
		glTranslatef(x + (widthHouse/2 + radiusCorner) + offsetRoof, y, heightHouse);
		glRotatef(-tiltRoofQuad, 0, 1, 0);
		glBegin(GL_QUADS);

		glNormal3f(1, 0, 0);
		glVertex3f(0, (lengthHouse + radiusCorner * 2)/2 + offsetRoof, 0);
		glNormal3f(1, 0, 0);
		glVertex3f(0, -(lengthHouse + radiusCorner * 2)/2 - offsetRoof, 0);
		glNormal3f(1, 0, 0);
		glVertex3f(0, -(lengthHouse + radiusCorner * 2)/2 - offsetRoof + offsetQuad, heightQuad);
		glNormal3f(1, 0, 0);
		glVertex3f(0, (lengthHouse + radiusCorner * 2)/2 + offsetRoof - offsetQuad, heightQuad);
		
		glEnd();
		glPopMatrix();
	}

	void CreateDL(UINT* tex, int roadTex, int roadVTex, int _sprSumGroundTex, int _autumnGroundTex, int _winterGroundTex, int _sprSumBackTex, int _autumnBackTex, int _winterBackTex, int _sprSumOrthTex, int _autumnOrthTex, int _winterOrthTex)
	{

		textures = tex;
		sprSumGroundTex = _sprSumGroundTex;
		autumnGroundTex = _autumnGroundTex;
		winterGroundTex = _winterGroundTex;
		sprSumBackTex = _sprSumBackTex;
		autumnBackTex = _autumnBackTex;
		winterBackTex = _winterBackTex;
		sprSumOrthTex = _sprSumOrthTex;
		autumnOrthTex = _autumnOrthTex;
		winterOrthTex = _winterOrthTex;

		int i = 1;

		worldList = glGenLists(i++);
		glNewList(worldList, GL_COMPILE);

		DrawTree(-1.5, -0.5);
		DrawTree(-1.5, 0.5);
		DrawTree(-1.5, 1.5);
		DrawTree(-1.5, 2.5);
		DrawTree(-1.5, 3.5);
		DrawTree(-1.5, 4.5);
		DrawTree(-1.5, 5.5);
		DrawTree(-1.5, 6.5);
		DrawTree(-1.5, 7.5);
		DrawTree(-1.5, 8.5);
		DrawTree(-1.5, 9.5);
		DrawTree(-1.5, 10.5);
		DrawTree(-1.5, 11.5);
		DrawTree(-1.5, 12.5);
		DrawTree(-1.5, 13.5);
		DrawTree(-1.5, 14.5);
		DrawTree(-1.5, 15.5);

		DrawTree(16.5, -0.5);
		DrawTree(16.5, 0.5);
		DrawTree(16.5, 1.5);
		DrawTree(16.5, 2.5);
		DrawTree(16.5, 3.5);
		DrawTree(16.5, 4.5);
		DrawTree(16.5, 5.5);
		DrawTree(16.5, 6.5);
		DrawTree(16.5, 7.5);
		DrawTree(16.5, 8.5);
		DrawTree(16.5, 9.5);
		DrawTree(16.5, 10.5);
		DrawTree(16.5, 11.5);
		DrawTree(16.5, 12.5);
		DrawTree(16.5, 13.5);
		DrawTree(16.5, 14.5);
		DrawTree(16.5, 15.5);

		DrawTree(-0.5, -0.5);
		DrawTree(-0.5, 0.5);
		DrawTree(-0.5, 1.5);
		DrawTree(-0.5, 2.5);
		DrawTree(-0.5, 3.5);
		DrawTree(-0.5, 4.5);
		DrawTree(-0.5, 5.5);
		DrawTree(-0.5, 6.5);
		DrawTree(-0.5, 7.5);
		DrawTree(-0.5, 8.5);
		DrawTree(-0.5, 9.5);
		DrawTree(-0.5, 10.5);
		DrawTree(-0.5, 11.5);
		DrawTree(-0.5, 12.5);
		DrawTree(-0.5, 13.5);
		DrawTree(-0.5, 14.5);
		DrawTree(-0.5, 15.5);

		DrawTree(15.5, -0.5);
		DrawTree(15.5, 0.5);
		DrawTree(15.5, 1.5);
		DrawTree(15.5, 2.5);
		DrawTree(15.5, 3.5);
		DrawTree(15.5, 4.5);
		DrawTree(15.5, 5.5);
		DrawTree(15.5, 6.5);
		DrawTree(15.5, 7.5);
		DrawTree(15.5, 8.5);
		DrawTree(15.5, 9.5);
		DrawTree(15.5, 10.5);
		DrawTree(15.5, 11.5);
		DrawTree(15.5, 12.5);
		DrawTree(15.5, 13.5);
		DrawTree(15.5, 14.5);
		DrawTree(15.5, 15.5);

		DrawTree(0.5, -0.5);
		DrawTree(1.5, -0.5);
		DrawTree(2.5, -0.5);
		DrawTree(3.5, -0.5);
		DrawTree(4.5, -0.5);
		DrawTree(5.5, -0.5);
		DrawTree(6.5, -0.5);
		DrawTree(7.5, -0.5);
		DrawTree(8.5, -0.5);
		DrawTree(9.5, -0.5);
		DrawTree(10.5, -0.5);
		DrawTree(11.5, -0.5);
		DrawTree(12.5, -0.5);
		DrawTree(13.5, -0.5);
		DrawTree(14.5, -0.5);

		DrawTree(0.5, 15.5);
		DrawTree(1.5, 15.5);
		DrawTree(2.5, 15.5);
		DrawTree(3.5, 15.5);
		DrawTree(4.5, 15.5);
		DrawTree(5.5, 15.5);
		DrawTree(6.5, 15.5);
		DrawTree(7.5, 15.5);
		DrawTree(8.5, 15.5);
		DrawTree(9.5, 15.5);
		DrawTree(10.5, 15.5);
		DrawTree(11.5, 15.5);
		DrawTree(12.5, 15.5);
		DrawTree(13.5, 15.5);
		DrawTree(14.5, 15.5);

		DrawTree(0.5, 16.5);
		DrawTree(1.5, 16.5);
		DrawTree(2.5, 16.5);
		DrawTree(3.5, 16.5);
		DrawTree(4.5, 16.5);
		DrawTree(5.5, 16.5);
		DrawTree(6.5, 16.5);
		DrawTree(7.5, 16.5);
		DrawTree(8.5, 16.5);
		DrawTree(9.5, 16.5);
		DrawTree(10.5, 16.5);
		DrawTree(11.5, 16.5);
		DrawTree(12.5, 16.5);
		DrawTree(13.5, 16.5);
		DrawTree(14.5, 16.5);

		DrawBoxHouse(1.5, 1.5);
		DrawCylinderHouse(3.5, 1.5);
		DrawBoxHouse(5.5, 1.5);
		DrawCylinderHouse(7.5, 1.5);
		DrawBoxHouse(9.5, 1.5);
		DrawCylinderHouse(11.5, 1.5);
		DrawBoxHouse(13.5, 1.5);

		DrawCylinderHouse(1.5, 3.5);
		DrawBoxHouse(3.5, 3.5);
		DrawCylinderHouse(5.5, 3.5);
		DrawBoxHouse(7.5, 3.5);
		DrawCylinderHouse(9.5, 3.5);
		DrawBoxHouse(11.5, 3.5);
		DrawCylinderHouse(13.5, 3.5);

		DrawBoxHouse(1.5, 5.5);
		DrawCylinderHouse(3.5, 5.5);
		DrawBoxHouse(5.5, 5.5);
		DrawCylinderHouse(7.5, 5.5);
		DrawBoxHouse(9.5, 5.5);
		DrawCylinderHouse(11.5, 5.5);
		DrawBoxHouse(13.5, 5.5);

		DrawCylinderHouse(1.5, 7.5);
		DrawBoxHouse(3.5, 7.5);
		DrawCylinderHouse(5.5, 7.5);
		DrawCylinderHouse(9.5, 7.5);
		DrawBoxHouse(11.5, 7.5);
		DrawCylinderHouse(13.5, 7.5);

		DrawBoxHouse(1.5, 9.5);
		DrawCylinderHouse(3.5, 9.5);

		DrawTree(6.35, 10.65);
		DrawTree(6.85, 10.65);
		DrawTree(6.35, 10.15);
		
		DrawTree(6.35, 8.35);
		DrawTree(6.35, 8.85);
		DrawTree(6.85, 8.35);
		
		DrawTree(8.15, 8.35);
		DrawTree(8.65, 8.35);
		DrawTree(8.65, 8.85);
		
		DrawTree(8.15, 10.65);
		DrawTree(8.65, 10.65);
		DrawTree(8.65, 10.15);

		DrawBoxHouse(11.5, 9.5);
		DrawCylinderHouse(13.5, 9.5);
	
		DrawCylinderHouse(1.5, 11.5);
		DrawBoxHouse(3.5, 11.5);
		DrawCylinderHouse(5.5, 11.5);
		DrawCylinderHouse(9.5, 11.5);
		DrawBoxHouse(11.5, 11.5);
		DrawCylinderHouse(13.5, 11.5);

		DrawBoxHouse(1.5, 13.5);
		DrawCylinderHouse(3.5, 13.5);
		DrawBoxHouse(5.5, 13.5);
		DrawCylinderHouse(7.5, 13.5);
		DrawBoxHouse(9.5, 13.5);
		DrawCylinderHouse(11.5, 13.5);
		DrawBoxHouse(13.5, 13.5);

		glEndList();

		backPlaneList = glGenLists(i++);
		glNewList(backPlaneList, GL_COMPILE);

		glBegin(GL_QUADS);
		glTexCoord2f(0, 1);
		glNormal3f(0.5, -0.5, 0);
		glVertex3f(-2, 17, 6.5);

		glTexCoord2f(1, 1);
		glNormal3f(-0.5, -0.5, 0);
		glVertex3f(17, 17, 6.5);

		glTexCoord2f(1, 0);
		glNormal3f(-0.5, -0.5, 0);
		glVertex3f(17, 17, -0.05);

		glTexCoord2f(0, 0);
		glNormal3f(0.5, -0.5, 0);
		glVertex3f(-2, 17, -0.05);

		glTexCoord2f(0, 1);
		glNormal3f(0.5, 0.5, 0);
		glVertex3f(-2, -2, 6.5);

		glTexCoord2f(1, 1);
		glNormal3f(0.5, -0.5, 0);
		glVertex3f(-2, 17, 6.5);

		glTexCoord2f(1, 0);
		glNormal3f(0.5, -0.5, 0);
		glVertex3f(-2, 17, -0.05);

		glTexCoord2f(0, 0);
		glNormal3f(0.5, 0.5, 0);
		glVertex3f(-2, -2, -0.05);
		
		glTexCoord2f(0, 1);
		glNormal3f(-0.5, -0.5, 0);
		glVertex3f(17, -2, 6.5);

		glTexCoord2f(1, 1);
		glNormal3f(-0.5, 0.5, 0);
		glVertex3f(17, 17, 6.5);

		glTexCoord2f(1, 0);
		glNormal3f(-0.5, 0.5, 0);
		glVertex3f(17, 17, -0.05);

		glTexCoord2f(0, 0);
		glNormal3f(-0.5, -0.5, 0);
		glVertex3f(17, -2, -0.05);

		glEnd();

		glEndList();

		groundPlaneList = glGenLists(i++);
		glNewList(groundPlaneList, GL_COMPILE);
		glBegin(GL_QUADS);
		glTexCoord2f(0.0f, 0.0f);
		glNormal3f(0, 0, 1);
		glVertex3f(0, 0, 0);
		glTexCoord2f(1.0f, 0.0f);
		glNormal3f(0, 0, 1);
		glVertex3f(1, 0, 0);
		glTexCoord2f(1.0f, 1.0f);
		glNormal3f(0, 0, 1);
		glVertex3f(1, 1, 0);
		glTexCoord2f(0.0f, 1.0f);
		glNormal3f(0, 0, 1);
		glVertex3f(0, 1, 0);
		glEnd();
		glEndList();
		
		orthPlaneList = glGenLists(i++);
		glNewList(orthPlaneList, GL_COMPILE);
		glCallList(backPlaneList);
		glBegin(GL_QUADS);
		glTexCoord2f(0, 1);
		glNormal3f(-0.5, 0.5, 0);
		glVertex3f(17, -2, 6.5);
		glTexCoord2f(1, 1);
		glNormal3f(0.5, -0.5, 0);
		glVertex3f(-2, -2, 6.5);
		glTexCoord2f(1, 0);
		glNormal3f(0.5, -0.5, 0);
		glVertex3f(-2, -2, -0.05);
		glTexCoord2f(0, 0);
		glNormal3f(-0.5, 0.5, 0);
		glVertex3f(17, -2, -0.05);
		glEnd();
		glEndList();

		sprSumBackList = glGenLists(i++);
		glNewList(sprSumBackList, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumBackTex]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		sprSumAutBack20List = glGenLists(i++);
		glNewList(sprSumAutBack20List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumBackTex + 1]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		sprSumAutBack40List = glGenLists(i++);
		glNewList(sprSumAutBack40List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumBackTex + 2]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		sprSumAutBack60List = glGenLists(i++);
		glNewList(sprSumAutBack60List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumBackTex + 3]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		sprSumAutBack80List = glGenLists(i++);
		glNewList(sprSumAutBack80List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumBackTex + 4]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		autumnBackList = glGenLists(i++);
		glNewList(autumnBackList, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnBackTex]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		autWintBack20List = glGenLists(i++);
		glNewList(autWintBack20List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnBackTex + 1]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		autWintBack40List = glGenLists(i++);
		glNewList(autWintBack40List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnBackTex + 2]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		autWintBack60List = glGenLists(i++);
		glNewList(autWintBack60List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnBackTex + 3]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		autWintBack80List = glGenLists(i++);
		glNewList(autWintBack80List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnBackTex + 4]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		winterBackList = glGenLists(i++);
		glNewList(winterBackList, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterBackTex]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		wintSprSumBack20List = glGenLists(i++);
		glNewList(wintSprSumBack20List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterBackTex + 1]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		wintSprSumBack40List = glGenLists(i++);
		glNewList(wintSprSumBack40List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterBackTex + 2]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		wintSprSumBack60List = glGenLists(i++);
		glNewList(wintSprSumBack60List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterBackTex + 3]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		wintSprSumBack80List = glGenLists(i++);
		glNewList(wintSprSumBack80List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterBackTex + 4]);
		glCallList(backPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		roadList = glGenLists(i++);
		glNewList(roadList, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[roadTex]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		roadVList = glGenLists(i++);
		glNewList(roadVList, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[roadVTex]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);						
		glEndList();

		roadHList = glGenLists(i++);
		glNewList(roadHList, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[roadVTex]);
		glPushMatrix();
		glTranslatef(1, 0, 0);
		glRotatef(90, 0, 0, 1);
		glCallList(groundPlaneList);
		glPopMatrix();
		glDisable(GL_TEXTURE_2D);							
		glEndList();

		sprSumGroundList = glGenLists(i++);
		glNewList(sprSumGroundList, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumGroundTex]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);							
		glEndList();

		sprSumAutGround20List = glGenLists(i++);
		glNewList(sprSumAutGround20List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumGroundTex + 1]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);							
		glEndList();

		sprSumAutGround40List = glGenLists(i++);
		glNewList(sprSumAutGround40List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumGroundTex + 2]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);							
		glEndList();

		sprSumAutGround60List = glGenLists(i++);
		glNewList(sprSumAutGround60List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumGroundTex + 3]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);							
		glEndList();

		sprSumAutGround80List = glGenLists(i++);
		glNewList(sprSumAutGround80List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumGroundTex + 4]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);							
		glEndList();

		autumnGroundList = glGenLists(i++);
		glNewList(autumnGroundList, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnGroundTex]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);								
		glEndList();

		autWintGround20List = glGenLists(i++);
		glNewList(autWintGround20List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnGroundTex + 1]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);								
		glEndList();

		autWintGround40List = glGenLists(i++);
		glNewList(autWintGround40List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnGroundTex + 2]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);								
		glEndList();

		autWintGround60List = glGenLists(i++);
		glNewList(autWintGround60List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnGroundTex + 3]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);								
		glEndList();

		autWintGround80List = glGenLists(i++);
		glNewList(autWintGround80List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnGroundTex + 4]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);								
		glEndList();

		winterGroundList = glGenLists(i++);
		glNewList(winterGroundList, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterGroundTex]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);							
		glEndList();

		wintSprSumGround20List = glGenLists(i++);
		glNewList(wintSprSumGround20List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterGroundTex + 1]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);							
		glEndList();

		wintSprSumGround40List = glGenLists(i++);
		glNewList(wintSprSumGround40List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterGroundTex + 2]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);							
		glEndList();

		wintSprSumGround60List = glGenLists(i++);
		glNewList(wintSprSumGround60List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterGroundTex + 3]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);							
		glEndList();

		wintSprSumGround80List = glGenLists(i++);
		glNewList(wintSprSumGround80List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterGroundTex + 4]);
		glCallList(groundPlaneList);
		glDisable(GL_TEXTURE_2D);							
		glEndList();

		boxHouseList = glGenLists(i++);
		glNewList(boxHouseList, GL_COMPILE);
		DrawBoxHouse(0.5, 0.5);
		glEndList();

		cylinderHouseList = glGenLists(i++);
		glNewList(cylinderHouseList, GL_COMPILE);
		DrawCylinderHouse(0.5, 0.5);
		glEndList();
		
		treeList = glGenLists(i++);
		glNewList(treeList, GL_COMPILE);
		DrawTree(-0.15, -0.15);
		DrawTree(-0.15, 0.35);
		DrawTree(0.35, -0.15);
		glEndList();

		singleTreeList = glGenLists(i++);
		glNewList(singleTreeList, GL_COMPILE);
		DrawTree(0, 0);
		glEndList();

		sprSumOrthList = glGenLists(i++);
		glNewList(sprSumOrthList, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumOrthTex]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		sprSumAutOrth20List = glGenLists(i++);
		glNewList(sprSumAutOrth20List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumOrthTex + 1]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		sprSumAutOrth40List = glGenLists(i++);
		glNewList(sprSumAutOrth40List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumOrthTex + 2]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		sprSumAutOrth60List = glGenLists(i++);
		glNewList(sprSumAutOrth60List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumOrthTex + 3]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		sprSumAutOrth80List = glGenLists(i++);
		glNewList(sprSumAutOrth80List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[sprSumOrthTex + 4]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		autumnOrthList = glGenLists(i++);
		glNewList(autumnOrthList, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnOrthTex]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		autWintOrth20List = glGenLists(i++);
		glNewList(autWintOrth20List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnOrthTex + 1]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		autWintOrth40List = glGenLists(i++);
		glNewList(autWintOrth40List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnOrthTex + 2]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		autWintOrth60List = glGenLists(i++);
		glNewList(autWintOrth60List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnOrthTex + 3]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		autWintOrth80List = glGenLists(i++);
		glNewList(autWintOrth80List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[autumnOrthTex + 4]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		winterOrthList = glGenLists(i++);
		glNewList(winterOrthList, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterOrthTex]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		wintSprSumOrth20List = glGenLists(i++);
		glNewList(wintSprSumOrth20List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterOrthTex + 1]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		wintSprSumOrth40List = glGenLists(i++);
		glNewList(wintSprSumOrth40List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterOrthTex + 2]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		wintSprSumOrth60List = glGenLists(i++);
		glNewList(wintSprSumOrth60List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterOrthTex + 3]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();

		wintSprSumOrth80List = glGenLists(i++);
		glNewList(wintSprSumOrth80List, GL_COMPILE);
		glEnable(GL_TEXTURE_2D);							
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[winterOrthTex + 4]);
		glCallList(orthPlaneList);
		glDisable(GL_TEXTURE_2D);
		glEndList();
		
		currentPercent = 0;
		currentGround = sprSumGroundList;
		currentOrth = sprSumOrthList;
		currentBack = sprSumBackList;
	}

	void RenderWorldFloor(float x, float y)
	{
		glColor3ub(darkGray[0], darkGray[1], darkGray[2]);
		glBegin(GL_QUADS);

		int beginX = (int)x - 1;
		int endX = (int)x + 2;
		int beginY = (int)y - 1;
		int endY = (int)y + 2;

		if (beginX < 0)
			beginX = 0;
		if (endX > 15)
			endX = 15;
		if (beginY < 0)
			beginY = 0;
		if (endY > 15)
			endY = 15;

		glNormal3f(0, 0, 1);
		glVertex3f(beginX, beginY, 0);
		glNormal3f(0, 0, 1);
		glVertex3f(endX, beginY, 0);
		glNormal3f(0, 0, 1);
		glVertex3f(endX, endY, 0);
		glNormal3f(0, 0, 1);
		glVertex3f(beginX, endY, 0);

		glEnd();
	}

	void RenderWorldFloor(float season)
	{
		if (season >= 0.2 && season <= 0.3)
		{
			//spring to autumn
			currentPercent = 1.0 - (0.3 - season) / 0.1;
			if (currentPercent >= 0.80)
			{
				currentGround = sprSumAutGround80List;
				currentBack = sprSumAutBack80List;
				currentOrth = sprSumAutOrth80List;
			}
			else if (currentPercent >= 0.60)
			{
				currentGround = sprSumAutGround60List;
				currentBack = sprSumAutBack60List;
				currentOrth = sprSumAutOrth60List;
			}
			else if (currentPercent >= 0.40)
			{
				currentGround = sprSumAutGround40List;
				currentBack = sprSumAutBack40List;
				currentOrth = sprSumAutOrth40List;
			}
			else if (currentPercent >= 0.20)
			{
				currentGround = sprSumAutGround20List;
				currentBack = sprSumAutBack20List;
				currentOrth = sprSumAutOrth20List;
			}
		}
		else if (season >= 0.45 && season <= 0.55)
		{
			//autumn to winter
			currentPercent = 1.0 - (0.55 - season) / 0.1;
			if (currentPercent >= 0.80)
			{
				currentGround = autWintGround80List;
				currentBack = autWintBack80List;
				currentOrth = autWintOrth80List;
			}
			else if (currentPercent >= 0.60)
			{
				currentGround = autWintGround60List;
				currentBack = autWintBack60List;
				currentOrth = autWintOrth60List;
			}
			else if (currentPercent >= 0.40)
			{
				currentGround = autWintGround40List;
				currentBack = autWintBack40List;
				currentOrth = autWintOrth40List;
			}
			else if (currentPercent >= 0.20)
			{
				currentGround = autWintGround20List;
				currentBack = autWintBack20List;
				currentOrth = autWintOrth20List;
			}
		}
		else if (season >= 0.7 && season <= 0.8)
		{
			//winter to spring
			currentPercent = 1.0 - (0.8 - season) / 0.1;
			if (currentPercent >= 0.80)
			{
				currentGround = wintSprSumGround80List;
				currentBack = wintSprSumBack80List;
				currentOrth = wintSprSumOrth80List;
			}
			else if (currentPercent >= 0.60)
			{
				currentGround = wintSprSumGround60List;
				currentBack = wintSprSumBack60List;
				currentOrth = wintSprSumOrth60List;
			}
			else if (currentPercent >= 0.40)
			{
				currentGround = wintSprSumGround40List;
				currentBack = wintSprSumBack40List;
				currentOrth = wintSprSumOrth40List;
			}
			else if (currentPercent >= 0.20)
			{
				currentGround = wintSprSumGround20List;
				currentBack = wintSprSumBack20List;
				currentOrth = wintSprSumOrth20List;
			}
		}
		else if (season > 0.78)
		{
			currentGround = sprSumGroundList;
			currentOrth = sprSumOrthList;
			currentBack = sprSumBackList;
		}
		else if (season > 0.53)
		{
			currentGround = winterGroundList;
			currentOrth = winterOrthList;
			currentBack = winterBackList;
		}
		else if (season > 0.28)
		{
			currentGround = autumnGroundList;
			currentOrth = autumnOrthList;
			currentBack = autumnBackList;
		}

		glCallList(currentBack);

		for (int i = -2; i <= length+1; i++)
		{
			for (int j = -2; j <= length+1; j++)
			{
				glPushMatrix();
				glTranslatef(i, j, 0);

				if (i <= -1 || j <= -1 || i >= length || j >= length)
					glCallList(currentGround);
				else if ((i >= 5 && i <= 9) && (j >= 7 && j <= 11))
					glCallList(currentGround);
				else if (i % 2 == 1 && j % 2 == 1)
					glCallList(currentGround);
				else if (i % 2 == 0 && j % 2 == 0)
					glCallList(roadList);
				else if (i % 2 == 1 && j % 2 == 0)
					glCallList(roadHList);
				else if (i % 2 == 0 && j % 2 == 1)
					glCallList(roadVList);
				glPopMatrix();
			}
		}
	}

	void RenderPlayerViewFloor(float pX, float pY, float dirX,float dirY)
	{
		glCallList(currentOrth);

		for (int i = -2; i <= length + 1; i++)
		{
			for (int j = -2; j <= length + 1; j++)
			{
				glPushMatrix();
				glTranslatef(i, j, 0);

				if ((dirY > 0 && (j <= (int)pY - 2 || (int)pX - i >= j - (int)pY + 4 || i - (int)pX >= j - (int)pY + 4))
					|| (dirY < 0 && (j >= (int)pY + 2 || (int)pX - i >= (int)pY - j + 4 || i - (int)pX >= (int)pY - j + 4))
					|| (dirX > 0 && (i <= (int)pX - 2 || (int)pY - j >= i - (int)pX + 4 || j - (int)pY >= i - (int)pX + 4))
					|| (dirX < 0 && (i >= (int)pX + 2 || (int)pY - j >= (int)pX - i + 4 || j - (int)pY >= (int)pX - i + 4)))
				{
					//do nothing
				}
				else if (i <= -1 || j <= -1 || i >= length || j >= length)
				{
					glPushMatrix();
					glTranslatef(0.5, 0.5, 0);
					glCallList(singleTreeList);
					glPopMatrix();
					glCallList(currentGround);
				}
				else if ((i >= 5 && i <= 9) && (j >= 7 && j <= 11))
				{
					if (i == 6 && j == 8)
					{
						glPushMatrix();
						glTranslatef(0.5, 0.5, 0);
						glCallList(treeList);
						glPopMatrix();
					}
					else if (i == 6 && j == 10)
					{
						glPushMatrix();
						glTranslatef(0.5, 0.5, 0);
						glRotatef(-90, 0, 0, 1);
						glCallList(treeList);
						glPopMatrix();
					}
					else if (i == 8 && j == 8)
					{
						glPushMatrix();
						glTranslatef(0.5, 0.5, 0);
						glRotatef(90, 0, 0, 1);
						glCallList(treeList);
						glPopMatrix();
					}
					else if (i == 8 && j == 10)
					{
						glPushMatrix();
						glTranslatef(0.5, 0.5, 0);
						glRotatef(180, 0, 0, 1);
						glCallList(treeList);
						glPopMatrix();
					}
					else if ((i == 5 || i == 9) && (j == 7 || j == 11))
						glCallList(cylinderHouseList);

					glCallList(currentGround);
				}
				else if (i % 2 == 1 && j % 2 == 1)
				{
					if (((i == 1 || i == 5 || i == 9 || i == 13) && (j == 1 || j == 5 || j == 13))
						|| ((i == 1 || i == 11) && j == 9)
						|| ((i == 3 || i == 7 || i == 11) && (j == 3 || j == 7 || j == 11)))
						glCallList(boxHouseList);
					else
						glCallList(cylinderHouseList);

					glCallList(currentGround);
				}
				else if (i % 2 == 0 && j % 2 == 0)
					glCallList(roadList);
				else if (i % 2 == 1 && j % 2 == 0)
					glCallList(roadHList);
				else if (i % 2 == 0 && j % 2 == 1)
					glCallList(roadVList);
				glPopMatrix();
			}
		}
	}

	void RenderWorldObjects()
	{
		glCallList(worldList);

	}

	void SetSnow(CFunSnow* snow_)
	{
		snow = snow_;
	}

private:
	CFunSnow* snow;
	float polySubdivisions;
	float length;
	float size;
	UINT* textures;
	int sprSumBackTex;
	int autumnBackTex;
	int winterBackTex;
	int sprSumGroundTex;
	int autumnGroundTex;
	int winterGroundTex;
	int sprSumOrthTex;
	int autumnOrthTex;
	int winterOrthTex;
	GLuint worldList;
	GLuint roadVList;
	GLuint roadHList;
	GLuint roadList;
	GLuint backPlaneList;
	GLuint groundPlaneList;
	GLuint orthPlaneList;
	GLuint sprSumBackList;
	GLuint sprSumAutBack20List;
	GLuint sprSumAutBack40List;
	GLuint sprSumAutBack60List;
	GLuint sprSumAutBack80List;
	GLuint autumnBackList;
	GLuint autWintBack20List;
	GLuint autWintBack40List;
	GLuint autWintBack60List;
	GLuint autWintBack80List;
	GLuint winterBackList;
	GLuint wintSprSumBack20List;
	GLuint wintSprSumBack40List;
	GLuint wintSprSumBack60List;
	GLuint wintSprSumBack80List;
	GLuint sprSumOrthList;
	GLuint sprSumAutOrth20List;
	GLuint sprSumAutOrth40List;
	GLuint sprSumAutOrth60List;
	GLuint sprSumAutOrth80List;
	GLuint autumnOrthList;
	GLuint autWintOrth20List;
	GLuint autWintOrth40List;
	GLuint autWintOrth60List;
	GLuint autWintOrth80List;
	GLuint winterOrthList;
	GLuint wintSprSumOrth20List;
	GLuint wintSprSumOrth40List;
	GLuint wintSprSumOrth60List;
	GLuint wintSprSumOrth80List;
	GLuint sprSumGroundList;
	GLuint sprSumAutGround20List;
	GLuint sprSumAutGround40List;
	GLuint sprSumAutGround60List;
	GLuint sprSumAutGround80List;
	GLuint autumnGroundList;
	GLuint autWintGround20List;
	GLuint autWintGround40List;
	GLuint autWintGround60List;
	GLuint autWintGround80List;
	GLuint winterGroundList;
	GLuint wintSprSumGround20List;
	GLuint wintSprSumGround40List;
	GLuint wintSprSumGround60List;
	GLuint wintSprSumGround80List;
	GLuint boxHouseList;
	GLuint cylinderHouseList;
	GLuint treeList;
	GLuint singleTreeList;
	GLuint currentGround;
	GLuint currentOrth;
	GLuint currentBack;
	float currentPercent;
};

#endif