#ifndef _GLITEM_H
#define _GLITEM_H

#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library
#include <gl\glut.h>

#define PI 3.1415926535897932384626433832795
#define PIdiv180 (PI/180.0)

class CFunItem
{
	public:
		float posX;
		float posY;
		int type;
		int taken;
		GLuint itemList;

		CFunItem(int itemType)
		{
			posX = -1;
			posY = -1;
			type = itemType;
			taken = 0;
			currentAngle = 0;

		}

		void CreateItemDL(GLuint* tex, int num)
		{

			textures = tex;
			texNum = num;

			float width = 0.3;
			float height = 0.6;
			float depth = 0.1;

			itemList = glGenLists(1);
			glNewList(itemList, GL_COMPILE);

			glEnable(GL_TEXTURE_2D);							// Enable Texture Mapping
			glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
			glBindTexture(GL_TEXTURE_2D, textures[texNum]);

			glColor3f(1, 1, 1);

			glBegin(GL_QUADS);
			glTexCoord2f(0, 0);
			glNormal3f(0, 1, 0);
			glVertex3f(-width, depth/2, 0);
			glTexCoord2f(1, 0);
			glNormal3f(0, 1, 0);
			glVertex3f(width, depth/2, 0);
			glTexCoord2f(1, 1);
			glNormal3f(0, 1, 0);
			glVertex3f(width, depth/2, height);
			glTexCoord2f(0, 1);
			glNormal3f(0, 1, 0);
			glVertex3f(-width, depth/2, height);

			glTexCoord2f(0, 0);
			glNormal3f(0, -1, 0);
			glVertex3f(-width, -depth/2, 0);
			glTexCoord2f(1, 0);
			glNormal3f(0, -1, 0);
			glVertex3f(width, -depth/2, 0);
			glTexCoord2f(1, 1);
			glNormal3f(0, -1, 0);
			glVertex3f(width, -depth/2, height);
			glTexCoord2f(0, 1);
			glNormal3f(0, -1, 0);
			glVertex3f(-width, -depth/2, height);

			glNormal3f(0, 0, -1);
			glVertex3f(-width, -depth/2, 0);
			glNormal3f(0, 0, -1);
			glVertex3f(width, -depth/2, 0);
			glNormal3f(0, 0, -1);
			glVertex3f(width, depth/2, 0);
			glNormal3f(0, 0, -1);
			glVertex3f(-width, depth/2, 0);

			glNormal3f(0, 0, 1);
			glVertex3f(-width, -depth/2, height);
			glNormal3f(0, 0, 1);
			glVertex3f(width, -depth/2, height);
			glNormal3f(0, 0, 1);
			glVertex3f(width, depth/2, height);
			glNormal3f(0, 0, 1);
			glVertex3f(-width, depth/2, height);

			glNormal3f(-1, 0, 0);
			glVertex3f(-width, depth/2, 0);
			glNormal3f(-1, 0, 0);
			glVertex3f(-width, -depth/2, 0);
			glNormal3f(-1, 0, 0);
			glVertex3f(-width, -depth/2, height);
			glNormal3f(-1, 0, 0);
			glVertex3f(-width, depth/2, height);

			glNormal3f(1, 0, 0);
			glVertex3f(width, -depth/2, 0);
			glNormal3f(1, 0, 0);
			glVertex3f(width, depth/2, 0);
			glNormal3f(1, 0, 0);
			glVertex3f(width, depth/2, height);
			glNormal3f(1, 0, 0);
			glVertex3f(width, -depth/2, height);

			glEnd();
			glDisable(GL_TEXTURE_2D);

			glEndList();
		}

		void CreateCheeseDL(GLuint* tex, int num)
		{

			textures = tex;
			texNum = num;
			float cheeseWidth = 0.15;
			float cheeseHeight = 0.2;
			float cheeseDepth = 0.3;
			float normalX1 = cos(tan(cheeseWidth / cheeseDepth));
			float normalY1 = sin(tan(cheeseWidth / cheeseDepth));
			float normalX2 = PI - cos(tan(cheeseWidth / cheeseDepth));
			float normalY2 = sin(tan(cheeseWidth / cheeseDepth));

			itemList = glGenLists(1);
			glNewList(itemList, GL_COMPILE);

			glPushMatrix();
			glEnable(GL_TEXTURE_2D);							// Enable Texture Mapping
			glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
			glBindTexture(GL_TEXTURE_2D, textures[texNum]);

			glRotatef(15, 0, 1, 0);
			glRotatef(-90, 0, 0, 1);

			glBegin(GL_QUADS);
			glTexCoord2f(0, 0);
			glNormal3f(0, 1, 0);
			glVertex3f(-cheeseWidth, -cheeseDepth/2, 0);
			glTexCoord2f(1, 0);
			glNormal3f(0, 1, 0);
			glVertex3f(cheeseWidth, -cheeseDepth/2, 0);
			glTexCoord2f(1, 1);
			glNormal3f(0, 1, 0);
			glVertex3f(cheeseWidth, -cheeseDepth/2, 0.2);
			glTexCoord2f(0, 1);
			glNormal3f(0, 1, 0);
			glVertex3f(-cheeseWidth, -cheeseDepth/2, 0.2);

			glTexCoord2f(0, 0);
			glNormal3f(0, 0, 1);
			glVertex3f(-cheeseWidth, -cheeseDepth/2, 0);
			glTexCoord2f(1, 0);
			glNormal3f(0, 0, 1);
			glVertex3f(cheeseWidth, -cheeseDepth/2, 0);
			glTexCoord2f(1, 1);
			glNormal3f(0, 0, 1);
			glVertex3f(0, cheeseDepth/2, 0);
			glTexCoord2f(0, 1);
			glNormal3f(0, 0, 1);
			glVertex3f(0, cheeseDepth/2, 0);

			glTexCoord2f(0, 0);
			glNormal3f(0, 0, 1);
			glVertex3f(-cheeseWidth, -cheeseDepth/2, 0.2);
			glTexCoord2f(1, 0);
			glNormal3f(0, 0, 1);
			glVertex3f(cheeseWidth, -cheeseDepth/2, 0.2);
			glTexCoord2f(1, 1);
			glNormal3f(0, 0, 1);
			glVertex3f(0, cheeseDepth/2, 0.2);
			glTexCoord2f(0, 1);
			glNormal3f(0, 0, 1);
			glVertex3f(0, cheeseDepth/2, 0.2);

			glTexCoord2f(0, 0);
			glNormal3f(normalX1, normalY1, 0);
			glVertex3f(0, cheeseDepth/2, 0);
			glTexCoord2f(1, 0);
			glNormal3f(normalX1, normalY1, 0);
			glVertex3f(cheeseWidth, -cheeseDepth/2, 0);
			glTexCoord2f(1, 1);
			glNormal3f(normalX1, normalY1, 0);
			glVertex3f(cheeseWidth, -cheeseDepth/2, 0.2);
			glTexCoord2f(0, 1);
			glNormal3f(normalX1, normalY1, 0);
			glVertex3f(0, cheeseDepth/2, 0.2);

			glTexCoord2f(0, 0);
			glNormal3f(normalX2, normalY2, 0);
			glVertex3f(0, cheeseDepth/2, 0);
			glTexCoord2f(1, 0);
			glNormal3f(normalX2, normalY2, 0);
			glVertex3f(-cheeseWidth, -cheeseDepth/2, 0);
			glTexCoord2f(1, 1);
			glNormal3f(normalX2, normalY2, 0);
			glVertex3f(-cheeseWidth, -cheeseDepth/2, 0.2);
			glTexCoord2f(0, 1);
			glNormal3f(normalX2, normalY2, 0);
			glVertex3f(0, cheeseDepth/2, 0.2);

			glEnd();
			glDisable(GL_TEXTURE_2D);
			glPopMatrix();

			glEndList();
		}

		void SetPosition(float x, float y)
		{
			posX = x;
			posY = y;
			taken = 0;
		}

		void Render()
		{
			if (!taken)
			{
				currentAngle = (currentAngle + 10) % 360;

				glPushMatrix();
				glTranslatef(posX, posY, 0.1);
				glRotatef(-30, 1, 0, 0);
				glRotatef((float)currentAngle, 0, 0, 1);
				if (type != 7)
					glCallList(itemList);
				else
				{
					glPushMatrix();
					glTranslatef(0, 0, 0.35);
					glColor3ub(204, 204, 51);
					glRotatef(-90, 1, 0, 0);
					gluCylinder(gluNewQuadric(), 0.22, 0.22, 0.1, 10, 10);
					gluDisk(gluNewQuadric(), 0, 0.22, 10, 10);
					glPushMatrix();
					glTranslatef(0, 0, 0.1);
					gluDisk(gluNewQuadric(), 0, 0.22, 10, 10);
					glPopMatrix();
					glPopMatrix();
				}
				glPopMatrix();
			}
		}

		void RenderCheese()
		{
			if (taken > 0)
				return;

			glPushMatrix();
			glTranslatef(posX, posY, 0.7);
			glCallList(itemList);
			glPopMatrix();
		}

	private:
		GLuint* textures;
		int texNum;
		int currentAngle;
};

#endif
