#ifndef _GLGRID_H
#define _GLGRID_H

#include <list>
using namespace std;

#include "glbomb.h"
#include "gldestructableobject.h"
#include "glitem.h"
#include "glwall.h"
#include "gltrap.h"
#include "glmaze.h"
#include "glparticles.h"
#include "randomc.h"

#define PI 3.1415926535897932384626433832795
#define PIdiv180 (PI/180.0)
#define EXPLOSIONRADIUS 0.35
#define EXPLOSIONTIME 500

//enum state {empty, nonDestructible, bomb, maze};
class Explosion
{
public:
	int x;
	int y;
	float igniteTime;

	Explosion(int _x, int _y, float time)
	{
		x = _x;
		y = _y;
		igniteTime = time;
	}
};

typedef list<Explosion> EList;

class CFunCell
{
public:
	CFunBomb* bomb;
	CFunCar* car;
	CFunItem* item;
	CFunWall* wall;
	CFunTrap* trap;
	bool empty;
	bool nonDestructible;
	bool destructible;

	CFunCell()
	{
		bomb = NULL;
		item = NULL;
		wall = NULL;
		trap = NULL;
		empty = true;
		trap = false;
		nonDestructible = false;
		destructible = false;
		car = NULL;
	}

	void UpdateEmpty()
	{
		if (!nonDestructible && !destructible)
			empty = true;
		else
			empty = false;
	}

	void SetNonDestructible()
	{
		nonDestructible = true;
		UpdateEmpty();
	}

	void RemoveNonDestructible()
	{
		nonDestructible = false;
		UpdateEmpty();
	}

	bool SetBomb(CFunBomb* aBomb)
	{
		if (empty && bomb == NULL)
		{
			bomb = aBomb;
			return true;
		}
		else
			return false;
	}

	bool SetCar(CFunCar* aCar, CFunItem* anItem)
	{
		if (empty)
		{
			destructible = true;
			car = aCar;
			UpdateEmpty();
			item = anItem;
			return true;
		}
		else
			return false;
	}

	bool SetItem(CFunItem* anItem)
	{
		if (!nonDestructible && item == NULL) // || (item != NULL && item->taken)))
		{
			item = anItem;
			return true;
		}
		else
			return false;
	}

	void SetTrap(CFunTrap* aTrap)
	{
		if (trap == NULL)
			trap = aTrap;
	}

	void SetWall(CFunWall* aWall)
	{
		if (wall == NULL)
			wall = aWall;
	}

	void ClearBomb()
	{
		bomb = NULL;
	}

	void DestroyCar()
	{
		car = NULL;
		destructible = false;
		UpdateEmpty();
	}

	void ClearItem(int player)
	{
		item->posX = -1;
		item->posY = -1;
		item->taken = player;
		item = NULL;
	}

	void ClearWall()
	{
		wall->posX = -1;
		wall->posY = -1;
		wall->destroyed = true;
		wall = NULL;
	}

	void ClearTrap()
	{
		trap->posX = -1;
		trap->posY = -1;
		trap->available = true;
		trap = NULL;
	}
};

// This is our camera class
class CFunGrid 
{
	public:
		float bombX[20];
		float bombY[20];
		bool player1Killed;
		bool player2Killed;
		bool player1InMaze;
		bool player2InMaze;
		TRanrotWGenerator* rg;
		CFunMaze* maze;
		bool enemiesKilled[4];
		float enemiesX[4];
		float enemiesY[4];
		CFunItem* items[95];

		CFunGrid(TRanrotWGenerator* randgen)
		{
			gameMatrix = new CFunCell**[15];
			for (int i = 0; i < 15; i++)
			{
				gameMatrix[i] = new CFunCell*[15];
				for (int j = 0; j < 15; j++)
				{
					gameMatrix[i][j] = new CFunCell();
					if (i%2 == 1 && j%2 == 1)
						gameMatrix[i][j]->SetNonDestructible();
				}
			}

			// Cells in front of the entrances
			gameMatrix[5][9]->RemoveNonDestructible();
			gameMatrix[7][7]->RemoveNonDestructible();
			gameMatrix[9][9]->RemoveNonDestructible();
			gameMatrix[7][11]->RemoveNonDestructible();

			// Maze
			gameMatrix[6][8]->SetNonDestructible();
			gameMatrix[6][9]->SetNonDestructible();
			gameMatrix[6][10]->SetNonDestructible();
			gameMatrix[7][8]->SetNonDestructible();
			gameMatrix[7][9]->SetNonDestructible();
			gameMatrix[7][10]->SetNonDestructible();
			gameMatrix[8][8]->SetNonDestructible();
			gameMatrix[8][9]->SetNonDestructible();
			gameMatrix[8][10]->SetNonDestructible();

			for (i = 0; i < 20; i++)
			{
				bombX[i] = -1;
				bombY[i] = -1;
			}
			for (i = 0; i < 7; i++)
			{
				traps[i] = new CFunTrap();
			}
			for (i = 0; i < 4; i++)
			{
				enemiesKilled[i] = false;
			}

			player1X = 0.5;
			player1Y = 0.5;
			player2X = 14.5;
			player2Y = 0.5;
			numCars = 90;
			numItems = 95;
			rg = randgen;
			maze = new CFunMaze(rg);
			player1Killed = false;
			player2Killed = false;
			player1InMaze = false;
			player2InMaze = false;
			playerRadius = 0;
			cheeseP1 = -1;
			cheeseP2 = -1;
		}

		void InitTextures(GLuint* tex, int _particleTex, int _cheeseTex, int _itemTex, int _wallTex, int _mazeTex)
		{
			textures = tex;
			particleTex = _particleTex;
			cheeseTex = _cheeseTex;
			itemTex = _itemTex;
			wallTex = _wallTex;
			mazeTex = _mazeTex;
		}

		void InitMaze()
		{
			maze->CreateMaze(textures, mazeTex);
		}

		void InitWalls()
		{
			for (int i = 0; i < 7; i++)
			{
				walls[i] = new CFunWall(textures, wallTex);
			}
		}

		void InitParticles()
		{
			particles = new CFunParticles(rg, textures, particleTex);
		}

		void SetRadius(float radius)
		{
			playerRadius = radius;
		}

		void Update(float posX, float posY, int player)
		{
			if (player == 1)
			{
				player1X = posX;
				player1Y = posY;
			}
			else if (player == 2)
			{
				player2X = posX;
				player2Y = posY;
			}
		}
		
		bool SetBomb(float x, float y, int bombID, int player, CFunBomb* theBomb)
		{
			bool success = gameMatrix[(int)x][(int)y]->SetBomb(theBomb);

			if (success)
			{
				bombX[10 * (player - 1) + bombID] = (int)x + 0.5;
				bombY[10 * (player - 1) + bombID] = (int)y + 0.5;
			}

			return success;
		}

		bool SetCar(CFunCar* aCar, int x, int y, CFunItem* anItem)
		{
			if (y == 0 || (y <= 1 && (x == 0 || x == 14)) 
				|| (x == 5 && y == 9) || (x == 7 && y == 7) || (x == 7 && y == 11) || (x == 9 && y == 9))
				return false;
			else
				return (gameMatrix[x][y]->SetCar(aCar, anItem));
		}

		bool SetItem(CFunItem* anItem, int x, int y)
		{
			if (((x <= 2 || x >= 12) && y == 0) || (y <= 1 && (x == 0 || x == 14)))
				return false;
			else
				return (gameMatrix[x][y]->SetItem(anItem));
		}

		bool SetCheese(int i, int x, int y)
		{
			for (int j = 90; j < i; j++)
			{
				if ((int)items[i]->posX == x && (int)items[i]->posY == y)
					return false;
			}
			return true;
		}

		void SetTrap(float x, float y)
		{
			if (gameMatrix[(int)x][(int)y]->trap == NULL && gameMatrix[(int)x][(int)y]->bomb == NULL)
			{
				int i = 0;
				int found = -1;
				while (found == -1 && i < 7)
				{
					if (traps[i]->available)
						found = i;
					i++;
				}
				if (found != -1)
				{
					traps[found]->SetPosition(x, y);
					gameMatrix[(int)x][(int)y]->SetTrap(traps[found]);
				}
			}
		}

		void SetWall(float x, float y)
		{
			if (gameMatrix[(int)x][(int)y]->trap == NULL && gameMatrix[(int)x][(int)y]->bomb == NULL)
			{
				int i = 0;
				int found = -1;
				while (found == -1 && i < 11)
				{
					if (walls[i]->destroyed)
						found = i;
					i++;
				}
				if (found != -1)
				{
					walls[found]->SetPosition(x, y);;
					gameMatrix[(int)x][(int)y]->SetWall(walls[found]);
				}
			}
		}

		void ClearBomb(float x, float y, int bombID, int player)
		{
			if (x != -1 && y != -1)
			{
				gameMatrix[(int)x][(int)y]->ClearBomb();
				bombX[10 * (player - 1) + bombID] = -1;
				bombY[10 * (player - 1) + bombID] = -1;
			}
		}
		
		void ClearTrap(float x, float y)
		{
			gameMatrix[(int)x][(int)y]->ClearTrap();
			RecycleItem(5);
		}

		void RenderExplosions()
		{
			int count = 0;

			float currentTime = glutGet(GLUT_ELAPSED_TIME);

			EList::iterator current = explosions.begin();
			EList::iterator next;

			if (!explosions.empty())
			{

				while (current != explosions.end())
				{
					next = ++current;
					current--;

					if (currentTime - current->igniteTime <= EXPLOSIONTIME)
					{
						glPushMatrix();
						glTranslatef((float) current->x + 0.5, (float) current->y + 0.5, EXPLOSIONRADIUS);
						particles->Render();
						glPopMatrix();
					}
					else
					{
						explosions.erase(current);
					}

					current = next;
				}
			}
		}

		float Absolute(float value)
		{
			if (value >= 0)
				return value;
			else 
				return -value;
		}

		bool DestroyAllIn(int x, int y, float igniteTime)
		{
			explosions.push_back(Explosion(x, y, igniteTime));

			bool killedSomeone = KillPlayersIn(x, y);


			CFunCell* cell = gameMatrix[x][y];

			if (cell->wall != NULL)
			{
				cell->ClearWall();
				RecycleItem(6);
				return false;
			}

			if (cell->destructible)
			{
				cell->car->DestroyCar();
				cell->DestroyCar();
				return false;
			}

			CFunBomb* aBomb = cell->bomb;
	
			if (aBomb != NULL)
			{
				if (!aBomb->exploding)
				{
					aBomb->exploding = true;
					aBomb->igniteTime = glutGet(GLUT_ELAPSED_TIME);
				}
				return false;
			}

			if (killedSomeone)
				return false;
			else
				return true;
		}

		bool KillPlayersIn(int x, int y)
		{
			bool killedSomeone = false;
			float minDistance = playerRadius - 0.1;

			if (((int)player1X == x && (int)player1Y == y) ||
				((Absolute(player1X - x) < minDistance || Absolute(player1X - (x + 1)) < minDistance) &&
				(Absolute(player1Y - y) < minDistance || Absolute(player1Y - (y + 1)) < minDistance)))
			{
				player1Killed = true;
				killedSomeone = true;
			}
		
			if (((int)player2X == x && (int)player2Y == y) ||
				((Absolute(player2X - x) < minDistance || Absolute(player2X - (x + 1)) < minDistance) &&
				(Absolute(player2Y - y) < minDistance || Absolute(player2Y - (y + 1)) < minDistance)))
			{
				player2Killed = true;
				killedSomeone = true;
			}

			for (int i = 0; i < 4; i++)
			{
				if (((int)enemiesX[i] == x && (int)enemiesY[i] == y) ||
					((Absolute(enemiesX[i] - x) < minDistance || Absolute(enemiesX[i] - (x + 1)) < minDistance) &&
					(Absolute(enemiesY[i] - y) < minDistance || Absolute(enemiesY[i] - (y + 1)) < minDistance)))
				{
					enemiesX[i] = -1;
					enemiesY[i] = -1;
					enemiesKilled[i] = true;
					killedSomeone = true;
				}
			}

			return killedSomeone;
		}
		
		void EnemyKillsPlayers(float x, float y)
		{
			float minDistance = 2 * playerRadius;

			float dXP1 = x - player1X;
			float dYP1 = y - player1Y;
			float dXP2 = x - player2X;
			float dYP2 = y - player2Y;
			float distanceP1 = sqrt(dXP1 * dXP1 + dYP1 * dYP1);
			float distanceP2 = sqrt(dXP2 * dXP2 + dYP2 * dYP2);

			if (distanceP1 <= minDistance)
				player1Killed = true;
		
			if (distanceP2 <= minDistance)
				player2Killed = true;
		}

		void ClearPlayerKilledFlag(int player)
		{
			if (player == 1)
			{
				player1Killed = false;
				player1X = 0.5;
				player1Y = 0.5;
			}
			else if (player == 2)
			{
				player2Killed = false;
				player2X = 14.5;
				player2Y = 0.5;
			}
		}

		bool IsNonDestructible(int x, int y)
		{
			return (gameMatrix[x][y]->nonDestructible);
		}

		void ComputeExplosion(CFunBomb* explodingBomb)
		{
			int i = 1;

			explodingBomb->computed = true;

			DestroyAllIn((int)(explodingBomb->posX), (int)(explodingBomb->posY), explodingBomb->igniteTime);

			int x1;
			int x2;
			int y1;
			int y2;

			bool north = true;
			bool south = true;
			bool west = true;
			bool east = true;

			while (i <= explodingBomb->explosionSize)
			{
				x1 = (int) (explodingBomb->posX) + i;
				x2 = (int) (explodingBomb->posX) - i;
				y1 = (int) (explodingBomb->posY) + i;
				y2 = (int) (explodingBomb->posY) - i;


				if (east && x1 < 15)
				{
					if (IsNonDestructible(x1, (int)(explodingBomb->posY)))
						east = false;
					else
						east = DestroyAllIn(x1, (int)(explodingBomb->posY), explodingBomb->igniteTime);
				}
				if (west && x2 >= 0)
				{
					if (IsNonDestructible(x2, (int)(explodingBomb->posY)))
						west = false;
					else
						west = DestroyAllIn(x2, (int)(explodingBomb->posY), explodingBomb->igniteTime);
				}
				if (north && y1 < 15)
				{
					if (IsNonDestructible((int)(explodingBomb->posX), y1))
						north = false;
					else
						north = DestroyAllIn((int)(explodingBomb->posX), y1, explodingBomb->igniteTime);
				}
				if (south && y2 >= 0)
				{
					if (IsNonDestructible((int)(explodingBomb->posX), y2))
						south = false;
					else
						south = DestroyAllIn((int)(explodingBomb->posX), y2, explodingBomb->igniteTime);
				}

				i++;
			}
		}

		bool IsEntrance(int x, int y)
		{	
			return (((int)x==6 || (int)x==8) && (int)y==9) || ((int)x==7 && ((int)y==8 || (int)y==10));
		}

		bool IsEmpty(float x, float y, float radius)
		{
			int east = x + radius;
			int north = y + radius;
			
			if (east >= 15)
				east = 14;

			if (north >= 15)
				north = 14;

			return (((gameMatrix[east][(int)y]->empty || IsEntrance(east, (int)y)) && (gameMatrix[(int)(x - radius)][(int)y]->empty || IsEntrance((int)(x - radius), (int)y)) && (gameMatrix[(int)x][north]->empty || IsEntrance((int)x, north)) && (gameMatrix[(int)x][(int)(y - radius)]->empty) || IsEntrance((int)x, (int)(y - radius))));
		}

		bool CheckBomb(float x, float y, float nextX, float nextY)
		{
			CFunBomb* aBomb = gameMatrix[(int)x][(int)y]->bomb;
			CFunBomb* nextBomb = gameMatrix[(int)nextX][(int)nextY]->bomb;

			if (aBomb == NULL && nextBomb == NULL)
				return true;
			else if (aBomb != NULL && nextBomb == NULL)
				return true;
			else if (aBomb != NULL && nextBomb != NULL)
				return (aBomb == nextBomb);
			else 
				return false;
		}

		bool CheckWall(float x, float y, float nextX, float nextY)
		{
			CFunWall* aWall = gameMatrix[(int)x][(int)y]->wall;
			CFunWall* nextWall = gameMatrix[(int)nextX][(int)nextY]->wall;

			if (aWall == NULL && nextWall == NULL)
				return true;
			else if (aWall != NULL && nextWall == NULL)
				return true;
			else if (aWall != NULL && nextWall != NULL)
				return (aWall == nextWall);
			else 
				return false;
		}

		bool CheckTrap(float x, float y, float nextX, float nextY)
		{
			CFunTrap* aTrap = gameMatrix[(int)x][(int)y]->trap;
			CFunTrap* nextTrap = gameMatrix[(int)nextX][(int)nextY]->trap;

			if (aTrap == NULL && nextTrap == NULL)
				return true;
			else if (aTrap != NULL && nextTrap == NULL)
				return true;
			else if (aTrap != NULL && nextTrap != NULL)
				return (aTrap == nextTrap);
			else 
				return false;
		}

		bool HasNoObject(float x, float y)
		{
			if (((int)x == 7 && ((int)y == 8 || (int)y == 10)) || ((int)y == 9 && ((int)x == 6 || (int)x == 8)))
				return false;
			return (gameMatrix[(int)x][(int)y]->wall == NULL && gameMatrix[(int)x][(int)y]->trap == NULL && gameMatrix[(int)x][(int)y]->bomb == NULL);
		}

		bool HasTrap(float x, float y)
		{
			return !(gameMatrix[(int)x][(int)y]->trap == NULL);
		}

		int CheckItem(float nextX, float nextY)
		{
			CFunItem* anItem = gameMatrix[(int)nextX][(int)nextY]->item;

			if (anItem == NULL)
				return -1;
			else if (!anItem->taken)
				return (anItem->type);
			else
				return -1;
		}

		void SetItemRandom(int i)
		{
			bool set = false;
			int x;
			int y;

			while (!set)
			{
				x = rg->IRandom(0, 14);
				y = rg->IRandom(0, 14);
				set = SetItem(items[i], x, y);

				if (set)
				{
					items[i]->SetPosition(x + 0.5, y + 0.5);
				}
			}
		}

		bool CheckCheese(float x, float y, int player)
		{
			int i;
			int found;

			i = 90;
			found = -1;
			while (found == -1 && i < 95)
			{
				if (!items[i]->taken && items[i]->posX == (int)x + 0.5 && items[i]->posY == (int)y + 0.5)
					found = i;
				i++;
			}
			if (found != -1)
			{
				items[found]->taken = player;
				return true;
			}
			else
				return false;
		}

		void PutDownCheese(float x, float y, int player)
		{
			int i;
			int found;
			bool set = false;

			i = 90;
			found = -1;
			while (found == -1 && i < 95)
			{
				if (items[i]->taken == player)
					found = i;
				i++;
			}
			if (found != -1)
			{		
				if ((int)x == 7 && (int)y == 8)
				{
					if (gameMatrix[7][7]->item == NULL)
					{
						gameMatrix[7][7]->SetItem(items[found]);
						items[found]->SetPosition(7.5, 7.5);
					}
					else
					{
						set = false;
						while (!set)
						{
							x = rg->IRandom(100, 100 + maze->mazeSize - 1);
							y = rg->IRandom(100, 100 + maze->mazeSize - 1);

							set = SetCheese(found, x, y);
							if (set)
								items[found]->SetPosition(x + 0.5, y + 0.5);
						}
					}

				}
				else if ((int)x == 7 && (int)y == 10)
				{
					if (gameMatrix[7][11]->item == NULL)
					{
						gameMatrix[7][11]->SetItem(items[found]);
						items[found]->SetPosition(7.5, 11.5);
					}
					else
					{
						set = false;
						while (!set)
						{
							x = rg->IRandom(100, 100 + maze->mazeSize - 1);
							y = rg->IRandom(100, 100 + maze->mazeSize - 1);

							set = SetCheese(found, x, y);
							if (set)
								items[found]->SetPosition(x + 0.5, y + 0.5);
						}
					}
				}
				else if ((int)x == 6 && (int)y == 9)
				{
					if (gameMatrix[5][9]->item == NULL)
					{
						gameMatrix[5][9]->SetItem(items[found]);
						items[found]->SetPosition(5.5, 9.5);
					}
					else
					{
						set = false;
						while (!set)
						{
							x = rg->IRandom(100, 100 + maze->mazeSize - 1);
							y = rg->IRandom(100, 100 + maze->mazeSize - 1);

							set = SetCheese(found, x, y);
							if (set)
								items[found]->SetPosition(x + 0.5, y + 0.5);
						}
					}
				}
				else if ((int)x == 8 && (int)y == 9)
				{
					if (gameMatrix[9][9]->item == NULL)
					{
						gameMatrix[9][9]->SetItem(items[found]);
						items[found]->SetPosition(9.5, 9.5);
					}
					else
					{
						set = false;
						while (!set)
						{
							x = rg->IRandom(100, 100 + maze->mazeSize - 1);
							y = rg->IRandom(100, 100 + maze->mazeSize - 1);

							set = SetCheese(found, x, y);
							if (set)
								items[found]->SetPosition(x + 0.5, y + 0.5);
						}
					}
				}
				else
				{
					if (gameMatrix[(int)x][(int)y]->item == NULL)
					{
						gameMatrix[(int)x][(int)y]->SetItem(items[found]);
						items[found]->SetPosition((int)x + 0.5, (int)y + 0.5);
					}
					else
					{
						set = false;
						while (!set)
						{
							x = rg->IRandom(100, 100 + maze->mazeSize - 1);
							y = rg->IRandom(100, 100 + maze->mazeSize - 1);

							set = SetCheese(found, x, y);
							if (set)
								items[found]->SetPosition(x + 0.5, y + 0.5);
						}
					}
				}
			}
		}

		void RecycleItem(int itemType)
		{
			int i;
			int found;

			switch (itemType)
			{
			case 1:
				i = 0;
				found = -1;
				while (found == -1 && i < 20)
				{
					if (items[i]->taken > 0)
						found = i;
					i++;
				}
				if (found != -1)
					SetItemRandom(found);
				break;

			case 2:
				i = 20;
				found = -1;
				while (found == -1 && i < 35)
				{
					if (items[i]->taken > 0)
						found = i;
					i++;
				}
				if (found != -1)
					SetItemRandom(found);
				break;

			case 3:
				i = 35;
				found = -1;
				while (found == -1 && i < 37)
				{
					if (items[i]->taken > 0)
						found = i;
					i++;
				}
				if (found != -1)
					SetItemRandom(found);
				break;

			case 4:
				i = 37;
				found = -1;
				while (found == -1 && i < 45)
				{
					if (items[i]->taken > 0)
						found = i;
					i++;
				}
				if (found != -1)
					SetItemRandom(found);
				break;

			case 5:
				i = 45;
				found = -1;
				while (found == -1 && i < 52)
				{
					if (items[i]->taken > 0)
						found = i;
					i++;
				}
				if (found != -1)
					SetItemRandom(found);
				break;

			case 6:
				i = 52;
				found = -1;
				while (found == -1 && i < 59)
				{
					if (items[i]->taken > 0)
						found = i;
					i++;
				}
				if (found != -1)
					SetItemRandom(found);
				break;

			default:
				break;
			}
		}

		void ClearItem(float nextX, float nextY, int player)
		{
			gameMatrix[(int)nextX][(int)nextY]->ClearItem(player);
		}

		void InitCarsAndObjects()
		{
			bool set;
			int x;
			int y;

			for (int i = 0; i < numCars; i++)
			{
				set = false;
				cars[i] = new CFunCar(*rg);
				if (i < 20)	//bomb
				{
					items[i] = new CFunItem(1);
					items[i]->CreateItemDL(textures, itemTex);
				}
				else if (i < 35) //speed
				{
					items[i] = new CFunItem(2);
					items[i]->CreateItemDL(textures, itemTex + 1);
				}
				else if (i < 37) //maxfire
				{
					items[i] = new CFunItem(3);
					items[i]->CreateItemDL(textures, itemTex + 3);
				}
				else if (i < 45) //fire
				{
					items[i] = new CFunItem(4);
					items[i]->CreateItemDL(textures, itemTex + 2);
				}
				else if (i < 52) //traps
				{
					items[i] = new CFunItem(5);
					items[i]->CreateItemDL(textures, itemTex + 5);
				}
				else if (i < 59) //walls
				{
					items[i] = new CFunItem(6);
					items[i]->CreateItemDL(textures, itemTex + 4);
				}
				else if (i < 90)
					items[i] = new CFunItem(7);	//coin

				while (!set)
				{
					x = rg->IRandom(0, 14);
					y = rg->IRandom(0, 14);

					set = SetCar(cars[i], x, y, items[i]);
					if (set)
					{
						cars[i]->SetPosition(x + 0.5, y + 0.5);
						if (i < numItems)
							items[i]->SetPosition(x + 0.5, y + 0.5);
					}
				}

				
			}
			
			for (i = 90; i < 95; i++)
			{
				items[i] = new CFunItem(8);  //cheese
				items[i]->CreateCheeseDL(textures, cheeseTex);
				set = false;
				while (!set)
				{
					x = rg->IRandom(100, 100 + maze->mazeSize - 1);
					y = rg->IRandom(100, 100 + maze->mazeSize - 1);

					set = SetCheese(i, x, y);
					if (set)
						items[i]->SetPosition(x + 0.5, y + 0.5);
				}
			}
		}

		void RenderCarsAndItemsPlayerView(float pX, float pY, float dirX, float dirY)
		{			
			RenderExplosions();

			for (int i = 0; i < numCars; i++)
			{
				int x = (int)(cars[i]->posX);
				int y = (int)(cars[i]->posY);

				if ((dirY > 0 && (y <= (int)pY - 2 || (int)pX - x >= y - (int)pY + 4 || x - (int)pX >= y - (int)pY + 4))
					|| (dirY < 0 && (y >= (int)pY + 2 || (int)pX - x >= (int)pY - y + 4 || x - (int)pX >= (int)pY - y + 4))
					|| (dirX > 0 && (x <= (int)pX - 2 || (int)pY - y >= x - (int)pX + 4 || y - (int)pY >= x - (int)pX + 4))
					|| (dirX < 0 && (x >= (int)pX + 2 || (int)pY - y >= (int)pX - x + 4 || y - (int)pY >= (int)pX - x + 4)))
				{
					//do nothing
				}
				else
					cars[i]->Render();

				if (i < numItems && (int)(items[i]->posX) >= 0 && (int)(items[i]->posY) >= 0 && gameMatrix[(int)(items[i]->posX)][(int)(items[i]->posY)]->car == NULL && gameMatrix[(int)(items[i]->posX)][(int)(items[i]->posY)]->bomb == NULL && gameMatrix[(int)(items[i]->posX)][(int)(items[i]->posY)]->wall == NULL)
				{
					x = (int)(items[i]->posX);
					y = (int)(items[i]->posY);

					if ((dirY > 0 && (y <= (int)pY - 2 || (int)pX - x >= y - (int)pY + 4 || x - (int)pX >= y - (int)pY + 4))
						|| (dirY < 0 && (y >= (int)pY + 2 || (int)pX - x >= (int)pY - y + 4 || x - (int)pX >= (int)pY - y + 4))
						|| (dirX > 0 && (x <= (int)pX - 2 || (int)pY - y >= x - (int)pX + 4 || y - (int)pY >= x - (int)pX + 4))
						|| (dirX < 0 && (x >= (int)pX + 2 || (int)pY - y >= (int)pX - x + 4 || y - (int)pY >= (int)pX - x + 4)))
					{
						//do nothing
					}
					else
						items[i]->Render();
				}
				
				if (i < 7)
					walls[i]->Render();

				if (i < 7)
					traps[i]->Render();
			}

			for (i = 90; i < 95; i++)
			{
				items[i]->RenderCheese();
			}			
		}

		void RenderCarsAndItems()
		{
			RenderExplosions();

			for (int i = 0; i < numCars; i++)
			{
				cars[i]->Render();

				if (i < numItems && (int)(items[i]->posX) >= 0 && (int)(items[i]->posY) >= 0 && gameMatrix[(int)(items[i]->posX)][(int)(items[i]->posY)]->car == NULL && gameMatrix[(int)(items[i]->posX)][(int)(items[i]->posY)]->bomb == NULL && gameMatrix[(int)(items[i]->posX)][(int)(items[i]->posY)]->wall == NULL)
					items[i]->Render();
				
				if (i < 7)
					walls[i]->Render();

				if (i < 7)
					traps[i]->Render();
			}

			for (i = 90; i < 95; i++)
			{
				items[i]->RenderCheese();
			}			
		}

		void RenderMaze()
		{
			maze->Render();

			for (int i = 90; i < 95; i++)
			{
				items[i]->RenderCheese();
			}
		}

		CFunItem** getItems()
		{
			return items;
		}

		CFunCell*** getMatrix()
		{
			return gameMatrix;
		}

		void UpdateEnemyPos(int id, float x, float y)
		{
			enemiesX[id-1] = x;
			enemiesY[id-1] = y;
		}

		float player1X;
		float player1Y;
	private:

		CFunCell*** gameMatrix;
		CFunCar* cars[90];
		CFunWall* walls[7];
		CFunTrap* traps[7];
		CFunParticles* particles;
		int numCars;
		int numItems;
		
		float player2X;
		float player2Y;
		float playerRadius;
		int cheeseP1;
		int cheeseP2;
		EList explosions;
		GLuint* textures;
		int particleTex;
		int cheeseTex;
		int itemTex;
		int wallTex;
		int mazeTex;
};


#endif
