#ifndef _GLENEMY_H
#define _GLENEMY_H

#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library
#include <gl\glut.h>

#define ENEMYSPEED 0.13

class CFunEnemy
{
public:
	float radius;	
	float posX;
	float posY;
	float speed;

	CFunEnemy(int _id, CFunGrid* grid)
	{
		id = _id;

		color[0] = 1;
		color[1] = 1;
		color[2] = 0;
		color[3] = 1;
		height = 0.6;
		//radius = 0.2;
		polySubdivisions = 20;
		dirX = 1;
		dirY = 0;
		dirRX = 0;
		dirRY = -1;
		gameGrid = grid;
		speed = ENEMYSPEED;
		maxLegYOffset = 0.01;
		minLegYOffset = -0.13;
		legYOffsetIncrement = 0.01;
		legYOffset = -0.06;
		radius = 0.26;
		upperRadius = 0.23;
		legRadius = 0.1;
		legXOffset = 0.17;
		legZOffset = 0;
		armRadius = 0.06;
		armXOffset = 0.2;
		armYOffset = -upperRadius + 0.1;
		armZOffset = 2 * radius + legZOffset - 0.22;
		backNoseRadius = 0.02;
		noseHeight = 0.05;
		noseZOffset = 2 * radius + legZOffset - 0.1;
		noseYOffset = -upperRadius; 
		frontEarRadius = 0.09;
		backEarRadius = 0.04;
		earHeight = 0.05;
		earZOffset = upperRadius + 2 * radius + legZOffset - 0.05;
		earXOffset = 0.18;
		earYOffset = 0.02;
		earTiltAngle = -100;
		eyeRadius = 0.022;
		eyeZOffset = 2 * radius + legZOffset - 0.04;
		eyeXOffset = 0.07;
		eyeYOffset = -upperRadius + eyeRadius - 0.01;
		whiskerRadius = 0.007;
		whiskerHeight = 0.1;
		whiskerTiltAngle1 = 80;
		whiskerTiltAngle2 = 110;
		whiskerZOffset1 = 2 * radius + legZOffset - 0.09;
		whiskerZOffset2 = 2 * radius + legZOffset - 0.11;
		whiskerXOffset = 0.08;
		whiskerYOffset = -upperRadius - 0.001;
		tailRadius = 0.02;
		tailHeight = 0.1;
		tailYOffset = radius - 0.05;
		tailZOffset = legZOffset + 0.12;
		rotationDegree = 90;
		distance = gameGrid->rg->IRandom(1, 6);
	}

	void CreateDL()
	{
		playerBodyList = glGenLists(1);
		glNewList(playerBodyList, GL_COMPILE);

		glPushMatrix();
		glTranslatef(0, 0, radius + legZOffset);
		glutSolidSphere(radius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(0, 0, radius + legZOffset);
		gluCylinder(gluNewQuadric(), radius, upperRadius, radius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(-armXOffset, armYOffset, armZOffset);
		glutSolidSphere(armRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(armXOffset, armYOffset, armZOffset);
		glutSolidSphere(armRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(0, tailYOffset, tailZOffset);
		glRotatef(-110, 1, 0, 0);
		gluCylinder(gluNewQuadric(), tailRadius, 0, tailHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glEndList();
	
		playerHeadList = glGenLists(2);
		glNewList(playerHeadList, GL_COMPILE);
	
		glPushMatrix();
		glTranslatef(0, 0, 2 * radius + legZOffset);
		glutSolidSphere(upperRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(-earXOffset, earYOffset, earZOffset);
		glRotatef(earTiltAngle, 1, 0, 0);
		glPushMatrix();
		glTranslatef(0, 0, earHeight);
		gluDisk(gluNewQuadric(), 0, backEarRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		gluCylinder(gluNewQuadric(), frontEarRadius, backEarRadius, earHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(earXOffset, earYOffset, earZOffset);
		glRotatef(earTiltAngle, 1, 0, 0);
		glPushMatrix();
		glTranslatef(0, 0, earHeight);
		gluDisk(gluNewQuadric(), 0, backEarRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		gluCylinder(gluNewQuadric(), frontEarRadius, backEarRadius, earHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glEndList();
		
		playerFaceList = glGenLists(3);
		glNewList(playerFaceList, GL_COMPILE);

		glPushMatrix();
		glTranslatef(-eyeXOffset, eyeYOffset, eyeZOffset);
		glutSolidSphere(eyeRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(eyeXOffset, eyeYOffset, eyeZOffset);
		glutSolidSphere(eyeRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(whiskerXOffset, whiskerYOffset, whiskerZOffset1);
		glRotatef(whiskerTiltAngle1, 0, 1, 0);
		gluCylinder(gluNewQuadric(), whiskerRadius, 0, whiskerHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(whiskerXOffset, whiskerYOffset, whiskerZOffset2);
		glRotatef(whiskerTiltAngle2, 0, 1, 0);
		gluCylinder(gluNewQuadric(), whiskerRadius, 0, whiskerHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(-whiskerXOffset, whiskerYOffset, whiskerZOffset1);
		glRotatef(-whiskerTiltAngle1, 0, 1, 0);
		gluCylinder(gluNewQuadric(), whiskerRadius, 0, whiskerHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(-whiskerXOffset, whiskerYOffset, whiskerZOffset2);
		glRotatef(-whiskerTiltAngle2, 0, 1, 0);
		gluCylinder(gluNewQuadric(), whiskerRadius, 0, whiskerHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(0, noseYOffset, noseZOffset);
		glRotatef(90, 1, 0, 0);
		gluCylinder(gluNewQuadric(), backNoseRadius, 0, noseHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glEndList();
	}

	void SetRandomPosition()
	{
		bool set = false;

		while (!set)
		{
			posX = gameGrid->rg->IRandom(0, 14) + 0.5;
			posY = gameGrid->rg->IRandom(0, 14) + 0.5;

			if (posY > 2 && gameGrid->IsEmpty(posX, posY, 0) && gameGrid->HasNoObject(posX, posY))
				set = true;	
		}

		gameGrid->UpdateEnemyPos(id, posX, posY);
	}

	void Render(bool shadow)
	{
		if (gameGrid->enemiesKilled[id-1])
			return;

		ForwardBackward();

		if (dirX > 0)
			rotationDegree = 90 + (atan(dirY/dirX) * OneEightyDivPI);
		else if (dirX < 0)
			rotationDegree = 270 + (atan(dirY/dirX) * OneEightyDivPI);
		else if (dirX == 0 && dirY > 0)
			rotationDegree = 180;
		else if (dirX == 0 && dirY < 0)
			rotationDegree = 0;

		legYOffset += legYOffsetIncrement;
		if (legYOffset > maxLegYOffset)
		{
			legYOffsetIncrement *= -1;
			legYOffset = maxLegYOffset + legYOffsetIncrement;
		}
		else if (legYOffset < minLegYOffset)
		{
			legYOffsetIncrement *= -1;
			legYOffset = minLegYOffset + legYOffsetIncrement;
		}

		glColor4f(0.3, 0.3, 0.3, 1);

		glPushMatrix();
		glTranslatef(posX, posY, 0);
		glRotatef(rotationDegree, 0, 0, 1);

		if (!shadow)
			glColor4f(1, 1, 1, 1);
		
		glPushMatrix();
		glTranslatef(0, 0, radius + legZOffset);
		glutSolidSphere(radius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(0, 0, radius + legZOffset);
		gluCylinder(gluNewQuadric(), radius, upperRadius, radius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(-legXOffset, legYOffset, legRadius);
		glutSolidSphere(legRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(legXOffset, -0.06 + (-0.06 - legYOffset), legRadius);
		glutSolidSphere(legRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(-armXOffset, armYOffset, armZOffset);
		glutSolidSphere(armRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(armXOffset, armYOffset, armZOffset);
		glutSolidSphere(armRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(0, tailYOffset, tailZOffset);
		glRotatef(-110, 1, 0, 0);
		gluCylinder(gluNewQuadric(), tailRadius, 0, tailHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		if (!shadow)
			glColor4f(color[0], color[1], color[2], color[3]);

		glPushMatrix();
		glTranslatef(0, 0, 2 * radius + legZOffset);
		glutSolidSphere(upperRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(-earXOffset, earYOffset, earZOffset);
		glRotatef(earTiltAngle, 1, 0, 0);
		glPushMatrix();
		glTranslatef(0, 0, earHeight);
		gluDisk(gluNewQuadric(), 0, backEarRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		gluCylinder(gluNewQuadric(), frontEarRadius, backEarRadius, earHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(earXOffset, earYOffset, earZOffset);
		glRotatef(earTiltAngle, 1, 0, 0);
		glPushMatrix();
		glTranslatef(0, 0, earHeight);
		gluDisk(gluNewQuadric(), 0, backEarRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();
		gluCylinder(gluNewQuadric(), frontEarRadius, backEarRadius, earHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		if (!shadow)
			glColor4f(0, 0, 0, 1);

		glPushMatrix();
		glTranslatef(-eyeXOffset, eyeYOffset, eyeZOffset);
		glutSolidSphere(eyeRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(eyeXOffset, eyeYOffset, eyeZOffset);
		glutSolidSphere(eyeRadius, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(whiskerXOffset, whiskerYOffset, whiskerZOffset1);
		glRotatef(whiskerTiltAngle1, 0, 1, 0);
		gluCylinder(gluNewQuadric(), whiskerRadius, 0, whiskerHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(whiskerXOffset, whiskerYOffset, whiskerZOffset2);
		glRotatef(whiskerTiltAngle2, 0, 1, 0);
		gluCylinder(gluNewQuadric(), whiskerRadius, 0, whiskerHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(-whiskerXOffset, whiskerYOffset, whiskerZOffset1);
		glRotatef(-whiskerTiltAngle1, 0, 1, 0);
		gluCylinder(gluNewQuadric(), whiskerRadius, 0, whiskerHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(-whiskerXOffset, whiskerYOffset, whiskerZOffset2);
		glRotatef(-whiskerTiltAngle2, 0, 1, 0);
		gluCylinder(gluNewQuadric(), whiskerRadius, 0, whiskerHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPushMatrix();
		glTranslatef(0, noseYOffset, noseZOffset);
		glRotatef(90, 1, 0, 0);
		gluCylinder(gluNewQuadric(), backNoseRadius, 0, noseHeight, polySubdivisions, polySubdivisions);
		glPopMatrix();

		glPopMatrix();

		gameGrid->EnemyKillsPlayers(posX, posY);
	}


	void ForwardBackward()
	{
		distance -= ENEMYSPEED;

		float nextX = posX + dirX * ENEMYSPEED;
		float nextY = posY + dirY * ENEMYSPEED;

		if (distance > 0 && 
			!(nextX + radius >= 6.0 && nextX - radius <= 9.0 && nextY + radius >= 8.0 && nextY - radius <= 11.0) &&
			(nextX >= 0 && nextX < 15 && nextY >= 0 && nextY < 15) &&
			(speed >= 0 && gameGrid->IsEmpty(nextX, nextY, radius) && gameGrid->CheckBomb(posX, posY, nextX, nextY) && gameGrid->CheckWall(posX, posY, nextX, nextY) && (
			  ((dirX == 0 && dirY > 0) && (nextY + radius <= 15))
			|| ((dirX == 0 && dirY < 0) && (nextY - radius >= 0))
			|| ((dirY == 0 && dirX > 0) && (nextX + radius <= 15))
			|| ((dirY == 0 && dirX < 0) && (nextX - radius >= 0))
			
			|| ((dirX > 0 && dirY > 0) && (nextX + radius <= 15 && nextY + radius <= 15))
			|| ((dirX > 0 && dirY < 0) && (nextX + radius <= 15 && nextY - radius >= 0))
			|| ((dirX < 0 && dirY > 0) && (nextX - radius >= 0 && nextY + radius <= 15))
			|| ((dirX < 0 && dirY < 0) && (nextX - radius >= 0 && nextY - radius >= 0))
			))
			)
		{
			if (gameGrid->HasTrap(nextX, nextY) && !gameGrid->HasTrap(posX, posY))
			{
				gameGrid->ClearTrap(nextX, nextY);
				SetRandomPosition();
			}
			else
			{
				if ((int)nextX == 7 && (int)nextY == 9)
					MessageBox(NULL, "inside 7,9", "error", MB_OK);
				
				posX = nextX;
				posY = nextY;

				gameGrid->UpdateEnemyPos(id, posX, posY);
			}
		}
		else
		{
			distance = gameGrid->rg->IRandom(1, 6);
			int direction = gameGrid->rg->IRandom(0, 3);
			switch(direction)
			{
			case 0:	//east
				dirX = 1;
				dirY = 0;
				dirRX = 0;
				dirRY = -1;
				break;
			case 1:	//west
				dirX = -1;
				dirY = 0;
				dirRX = 0;
				dirRY = 1;
				break;
			case 2:	//north
				dirX = 0;
				dirY = 1;
				dirRX = 1;
				dirRY = 0;
				break;
			case 3:	//south
				dirX = 0;
				dirY = -1;
				dirRX = -1;
				dirRY = 0;
				break;
			default: //north
				dirX = 0;
				dirY = 1;
				dirRX = 1;
				dirRY = 0;
				break;

			}
		}
	}

private:
	int id;
	float color[4];
	float height;
	float polySubdivisions;
	float dirX;
	float dirY;
	float dirRX;
	float dirRY;
	CFunGrid* gameGrid;
	float upperRadius;
	float legRadius;
	float maxLegYOffset;
	float minLegYOffset;
	float legYOffsetIncrement;
	float legYOffset;
	float legXOffset;
	float legZOffset;
	float armRadius;
	float armXOffset;
	float armYOffset;
	float armZOffset;
	float backNoseRadius;
	float noseHeight;
	float noseZOffset;
	float noseYOffset; 
	float frontEarRadius;
	float backEarRadius;
	float earHeight;
	float earZOffset;
	float earXOffset;
	float earYOffset;
	float earTiltAngle;
	float eyeRadius;
	float eyeZOffset;
	float eyeXOffset;
	float eyeYOffset;
	float whiskerRadius;
	float whiskerHeight;
	float whiskerTiltAngle1;
	float whiskerTiltAngle2;
	float whiskerZOffset1;
	float whiskerZOffset2;
	float whiskerXOffset;
	float whiskerYOffset;
	float tailRadius;
	float tailHeight;
	float tailYOffset;
	float tailZOffset;
	float rotationDegree;
	float distance;
	GLuint playerBodyList;
	GLuint playerHeadList;
	GLuint playerFaceList;
};

#endif