#ifndef _GLDISJOINTSETS_H
#define _GLDISJOINTSETS_H

class CFunDisjointSets
{
	public:
		int numComponents;
		
		CFunDisjointSets(int numElements)
		{
			if (numElements >= 0)
			{
				component = new int[numElements];
				rank = new int[numElements];
				
				numComponents = numElements;
				for (int i = 0; i < numElements; i++)
				{
					component[i] = i;
					rank[i] = i;
				}
			}
		}

		int Find(int x)
		{
			if (component[x] == x)
				return x;
			return component[x] = Find(component[x]);
		}

		void UnionRoots(int root1, int root2)
		{
			if (rank[root2] < rank[root1])
				component[root1] = root2;
			else if (rank[root1] > rank[root2])
				component[root2] = root1;
			else
			{
				component[root1] = root2;
				rank[root2]++;
			}
			numComponents--;
		}

		void Union(int x, int y)
		{
			if (Find(x) != Find(y))
				UnionRoots(Find(x), Find(y));
		}

	private:
		int* component;
		int* rank;
};


#endif
