#ifndef _GLDESTRUCTABLEOBJECT_H
#define _GLDESTRUCTABLEOBJECT_H

#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library
#include <time.h>

#include "glcolorpalette.h"
#include "randomc.h"

#define GEN_RANDOM_FLOAT (((float)rand())/RAND_MAX)

float carAmbient[4] = {0.19225, 0.19225, 0.19225, 1.0};
float carDiffuse[4] = {0.50754, 0.50754, 0.50754, 1.0};
float carSpecular[4] = {0.508273, 0.508273, 0.508273, 1.0};
float carEmission[4] = {0.0, 0.0, 0.0, 0.0};
float carShine[1] = {51.2};

float tiresAmbient[4] = {0.02, 0.02, 0.02, 1.0};
float tiresDiffuse[4] = {0.01, 0.01, 0.01, 1.0};
float tiresSpecular[4] = {0.4, 0.4, 0.4, 1.0};
float tiresEmission[4] = {0.0, 0.0, 0.0, 0.0};
float tiresShine[1] = {10};

class CFunCar
{
public: 
	float posX;
	float posY;
	bool destroyed;

	CFunCar(TRanrotWGenerator& rg)
	{
		destroyed = false;
		carBodyRadius = 0.3;
		frontBackRadius = 0.15;
		frontBackOffset = 0.25;
		frontBackWidth = 0.55;
		bottomBoxHeight = 0.08;
		carWidth = 0.5;
		wheelRadius = 0.1;
		wheelWidth = 0.56;
		windowWidth = 0.65;

		int randomNumber = rg.IRandom(0, 6);

		switch (randomNumber)
		{
		case 0:
			carColor[0] = violet[0];
			carColor[1] = violet[1];
			carColor[2] = violet[2];
			break;
		case 1:
			carColor[0] = white[0];
			carColor[1] = white[1];
			carColor[2] = white[2];
			break;
		case 2:
			carColor[0] = purple[0];
			carColor[1] = purple[1];
			carColor[2] = purple[2];
			break;
		case 3:
			carColor[0] = yellow[0];
			carColor[1] = yellow[1];
			carColor[2] = yellow[2];
			break;
		case 4:
			carColor[0] = blue[0];
			carColor[1] = blue[1];
			carColor[2] = blue[2];
			break;
		case 5:
			carColor[0] = orange[0];
			carColor[1] = orange[1];
			carColor[2] = orange[2];
			break;
		case 6:
			carColor[0] = green[0];
			carColor[1] = green[1];
			carColor[2] = green[2];
			break;
		}
	}

	void SetPosition(float x, float y)
	{
		posX = x;
		posY = y;		
	}

	void gluMyCylinder(float x, float y, float z, float radius, float height, float gap, float color[], float subdivisions, float rz)
	{
		double degree = 3.14 * 2 / subdivisions;
		double theta = 0;
		double rCosTheta = radius;
		double rSinTheta = 0;
		double nextRSinTheta;
		double nextRCosTheta; 

		glColor3ub(color[0], color[1], color[2]);

		glPushMatrix();
		glTranslatef(x, y, z);
		glRotatef(rz, 0, 0, 1);

		for (int i = 1; i < (subdivisions - gap + 1); i++)
		{
			theta += degree;
			nextRCosTheta = radius * cos(theta);
			nextRSinTheta = radius * sin(theta);
			
			// Top
			glBegin(GL_TRIANGLES);
				glNormal3f(0, 0, 1);
				glVertex3f(0, 0, height);
				glNormal3f(0, 0, 1);
				glVertex3f(rCosTheta, rSinTheta, height);
				glNormal3f(0, 0, 1);
				glVertex3f(nextRCosTheta, nextRSinTheta, height);
			glEnd();

			// Bottom
			glBegin(GL_TRIANGLES);
				glNormal3f(0, 0, -1);
				glVertex3f(0, 0, 0);
				glNormal3f(0, 0, -1);
				glVertex3f(rCosTheta, rSinTheta, 0);
				glNormal3f(0, 0, -1);
				glVertex3f(nextRCosTheta, nextRSinTheta, 0);
			glEnd();
		
			// Side
			glBegin(GL_TRIANGLE_STRIP);
				glNormal3f((radius * cos(theta - degree)), (radius * sin(theta - degree)), 0);
				glVertex3f(rCosTheta, rSinTheta, 0);
				glNormal3f(nextRCosTheta, nextRSinTheta, 0);
				glVertex3f(nextRCosTheta, nextRSinTheta, 0);
				glNormal3f((radius * cos(theta - degree)), (radius * sin(theta - degree)), 0);
				glVertex3f(rCosTheta, rSinTheta, height);
				glNormal3f(nextRCosTheta, nextRSinTheta, 0);
				glVertex3f(nextRCosTheta, nextRSinTheta, height);
			glEnd();

			rCosTheta = nextRCosTheta;
			rSinTheta = nextRSinTheta;
		}

		glPopMatrix();	
	}

	void gluBox(float x, float y, float z, float width, float length, float height, float color[])
	{

		glColor3ub(color[0], color[1], color[2]);

		glPushMatrix();
		glTranslatef(x, y, z);

		glBegin(GL_QUADS);
		//Top
		glNormal3f(0, 0, 1);
		glVertex3f(-width/2, -length/2, height);
		glNormal3f(0, 0, 1);
		glVertex3f(width/2, -length/2, height);
		glNormal3f(0, 0, 1);
		glVertex3f(width/2, length/2, height);
		glNormal3f(0, 0, 1);
		glVertex3f(-width/2, length/2, height);

		//Bottom
		glNormal3f(0, 0, -1);
		glVertex3f(-width/2, -length/2, 0);
		glNormal3f(0, 0, -1);
		glVertex3f(width/2, -length/2, 0);
		glNormal3f(0, 0, -1);
		glVertex3f(width/2, length/2, 0);
		glNormal3f(0, 0, -1);
		glVertex3f(-width/2, length/2, 0);

		//East
		glNormal3f(1, 0, 0);
		glVertex3f(width/2, -length/2, 0);
		glNormal3f(1, 0, 0);
		glVertex3f(width/2, length/2, 0);
		glNormal3f(1, 0, 0);
		glVertex3f(width/2, length/2, height);
		glNormal3f(1, 0, 0);
		glVertex3f(width/2, -length/2, height);

		//West
		glNormal3f(-1, 0, 0);
		glVertex3f(-width/2, length/2, 0);
		glNormal3f(-1, 0, 0);
		glVertex3f(-width/2, -length/2, 0);
		glNormal3f(-1, 0, 0);
		glVertex3f(-width/2, -length/2, height);
		glNormal3f(-1, 0, 0);
		glVertex3f(-width/2, length/2, height);

		//North
		glNormal3f(0, 1, 0);
		glVertex3f(-width/2, length/2, 0);
		glNormal3f(0, 1, 0);
		glVertex3f(width/2, length/2, 0);
		glNormal3f(0, 1, 0);
		glVertex3f(width/2, length/2, height);
		glNormal3f(0, 1, 0);
		glVertex3f(-width/2, length/2, height);

		//South
		glNormal3f(0, -1, 0);
		glVertex3f(-width/2, -length/2, 0);
		glNormal3f(0, -1, 0);
		glVertex3f(width/2, -length/2, 0);
		glNormal3f(0, -1, 0);
		glVertex3f(width/2, -length/2, height);
		glNormal3f(0, -1, 0);
		glVertex3f(-width/2, -length/2, height);

		glEnd();
		
		glPopMatrix();	
	}

	void DrawCar()
	{
		float carSubdivision = 24;
		
		glPushMatrix();
		glTranslatef(posX, posY + 1.5 * (wheelRadius + bottomBoxHeight), 0); 
		glRotatef(90, 1, 0, 0);
		glMaterialfv(GL_FRONT, GL_AMBIENT, carAmbient);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, carDiffuse);
		glMaterialfv(GL_FRONT, GL_SPECULAR, carSpecular);
		glMaterialfv(GL_FRONT, GL_EMISSION, carEmission);
		glMaterialfv(GL_FRONT, GL_SHININESS, carShine);
		gluMyCylinder(0, wheelRadius + bottomBoxHeight, 0, carBodyRadius, carWidth, carSubdivision/2, carColor, carSubdivision, 0);
		gluMyCylinder(-frontBackOffset, wheelRadius + bottomBoxHeight, 0, frontBackRadius, frontBackWidth, carSubdivision/2, carColor, carSubdivision, 0);
		gluMyCylinder(frontBackOffset, wheelRadius + bottomBoxHeight, 0, frontBackRadius, frontBackWidth, carSubdivision/2, carColor, carSubdivision, 0);
		gluBox(0, wheelRadius + bottomBoxHeight/2, 0, carBodyRadius * 2, bottomBoxHeight, carWidth, carColor);
		gluBox(-frontBackOffset, wheelRadius + bottomBoxHeight/2, 0, frontBackRadius * 2, bottomBoxHeight, frontBackWidth, carColor);
		gluBox(frontBackOffset, wheelRadius + bottomBoxHeight/2, 0, frontBackRadius * 2, bottomBoxHeight, frontBackWidth, carColor);

		glMaterialfv(GL_FRONT, GL_AMBIENT, defaultAmbient);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, defaultDiffuse);
		glMaterialfv(GL_FRONT, GL_SPECULAR, defaultSpecular);
		glMaterialfv(GL_FRONT, GL_EMISSION, defaultEmission);
		glMaterialfv(GL_FRONT, GL_SHININESS, defaultShine);
		gluMyCylinder(-frontBackOffset, wheelRadius, 0, wheelRadius, wheelWidth, 0, darkGray, carSubdivision, 0);
		gluMyCylinder(frontBackOffset, wheelRadius, 0, wheelRadius, wheelWidth, 0, darkGray, carSubdivision, 0);
		glPopMatrix();	
	}

	void Render()
	{
		if (!destroyed)
			DrawCar();
	}

	void DestroyCar()
	{
		destroyed = true;
	}

private:
	float carBodyRadius;
	float frontBackRadius;
	float frontBackOffset;
	float frontBackWidth;
	float bottomBoxHeight;
	float carWidth;
	float wheelRadius;
	float wheelWidth;
	float windowWidth;
	float carColor[3];
};

#endif