#ifndef _GLCRYSTALS_H
#define _GLCRYSTALS_H

#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library
#include <gl\glut.h>

#include "randomc.h"

#define PI 3.1415926535897932384626433832795
#define PIdiv180 (PI/180.0)

#define MAX_CRYSTALS 1000

typedef struct						
{
	bool active;				
	float life;					
	float fade;					
	float posX;					
	float posY;					
	float posZ;					
	float dirX;					
	float dirY;				
	float dirZ;				
} crystal;

crystal crystals[MAX_CRYSTALS];

float crystalColor[3] = {1.0, 0.3, 0.0};


class CFunCrystals
{
	public:

		CFunCrystals(TRanrotWGenerator* randgen, GLuint* tex, int num)
		{	
			rg = randgen;
			slowdown = 2.0;
			zoom = -40.0;
			stop = false;

			textures = tex;
			textureNum = num;

			for (int i = 0; i < MAX_CRYSTALS; i++)				
			{
				crystals[i].active = true;								
				crystals[i].life = 0.75;								
				crystals[i].fade = float(rg->IRandom(0, 15)) / 1000.0;	
				crystals[i].posX = float(rg->IRandom(0, 1500)) / 100.0;					
				crystals[i].posY = float(rg->IRandom(0, 1500)) / 100.0;						
				crystals[i].posZ = 7.5;					
				crystals[i].dirX = float((rg->IRandom(0, 40)) - 20.0);		
				crystals[i].dirY = float((rg->IRandom(0, 40)) - 20.0);	
				crystals[i].dirZ = float(rg->IRandom(-40, -20));	
			}

		}

		void Stop()
		{
			stop = true;
		}

		void Render()
		{
			glDisable(GL_DEPTH_TEST);							
			glEnable(GL_BLEND);									
			glBlendFunc(GL_SRC_ALPHA,GL_ONE);					
			glEnable(GL_TEXTURE_2D);							
			glBindTexture(GL_TEXTURE_2D, textures[textureNum]);		

			for (int i = 0; i < MAX_CRYSTALS; i++)					
			{
				if (crystals[i].active)							
				{
					float x = crystals[i].posX;						
					float y = crystals[i].posY;					
					float z = crystals[i].posZ;					

					glColor4f(crystalColor[0], crystalColor[1], crystalColor[2], crystals[i].life);

					glBegin(GL_TRIANGLE_STRIP);						
						glTexCoord2d(1,1);
						glVertex3f(x+0.06f,y,z+0.06f); // Top Right
						glTexCoord2d(0,1);
						glVertex3f(x-0.06f,y,z+0.06f); // Top Left
						glTexCoord2d(1,0);
						glVertex3f(x+0.06f,y,z-0.06f); // Bottom Right
						glTexCoord2d(0,0);
						glVertex3f(x-0.06f,y,z-0.06f); // Bottom Left
					glEnd();

					crystals[i].posX += crystals[i].dirX / (slowdown * 1000);
					crystals[i].posY += crystals[i].dirY / (slowdown * 1000);
					crystals[i].posZ += crystals[i].dirZ / (slowdown * 1000);

					crystals[i].life -= crystals[i].fade;		

					if (!stop && crystals[i].life < 0.0) 
					{
	
						crystals[i].active = true;							
						crystals[i].life = 0.75;							
						crystals[i].fade = float(rg->IRandom(0, 15)) / 1000.0;	
						crystals[i].posX = float(rg->IRandom(0, 1500)) / 100.0;						
						crystals[i].posY = float(rg->IRandom(0, 1500)) / 100.0;					
						crystals[i].posZ = 7.0;					
						crystals[i].dirX = float((rg->IRandom(0, 40)) - 20.0);		
						crystals[i].dirY = float((rg->IRandom(0, 40)) - 20.0);	
						crystals[i].dirZ = float(rg->IRandom(-40, -20));		
					}
				}
			}
			glEnable(GL_DEPTH_TEST);						
			glDisable(GL_BLEND);									
			glDisable(GL_TEXTURE_2D);						
		}

	private:
		TRanrotWGenerator* rg;
		float slowdown;
		float zoom;
		GLuint* textures;
		int textureNum;
		bool stop;
};

#endif
