#ifndef _GLCLOUDS_H
#define _GLCLOUDS_H

#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library

#include "glparticles.h"
#include "randomc.h"

class CFunClouds
{
public: 
	CFunClouds()
	{
	}
	
	void Initialize(TRanrotWGenerator* randgen, GLuint* textures, int i)
	{
		rg = randgen;
		particles = new CFunParticles(1, rg, textures, i);
	}

	void Render()
	{
		glPushMatrix();
		particles->Render();
		glPopMatrix();
	}

	void Stop()
	{
		particles->Stop();
	}

private:
	CFunParticles* particles;
	TRanrotWGenerator* rg;
};

#endif


