#include "main.h"
#include "glvector.h"
#include "glcamera.h"


#include <iostream.h>

float dTime = 0.0f;

CFunCamera::CFunCamera()
{
	CVector3 vZero = CVector3(0.0, 0.0, 0.0);		// Init a vVector to 0 0 0 for our position
	CVector3 vView = CVector3(0.0, 1.0, 0.0);		// Init a starting view vVector  
	CVector3 vUp   = CVector3(0.0, 0.0, 1.0);		// Init a standard up vVector 

	vCameraPosition	= vZero;					// Init the position to zero
	vCameraView		= vView;					// Init the view to a std starting view
	vCameraUp	= vUp;						// Init the UpVector
	vCameraRight = CVector3(1.0, 0.0, 0.0);

	type = 0;
	control = false;
	kSpeed = 0.5;
	timeBased = false;
}	

void CFunCamera::PositionCamera(float positionX, float positionY, float positionZ,
				  		     float viewX,     float viewY,     float viewZ,
							 float upVectorX, float upVectorY, float upVectorZ)
{
	CVector3 vNewPosition	= CVector3(positionX, positionY, positionZ);
	CVector3 vNewView		= CVector3(viewX, viewY, viewZ);
	CVector3 vNewUpVector	= CVector3(upVectorX, upVectorY, upVectorZ);

	vCameraPosition = vNewPosition;	
	vCameraView     = vNewView;		
	vCameraUp = vNewUpVector;	

	UpdateRightVector();
}

void CFunCamera::SetType(int theType)
{
	if (theType == 0)
	{
		type = 0;
		control = false;
	}

	else 	
	{
		if (theType == 1)
			type = 1;
		else if (theType == 2)
			type = 2;
		control = true;
	}
}

void CFunCamera::MouseInput()
{
	float degreeSensitivity = 45;
	POINT mousePos;									// This is a window structure that holds an X and Y
	int middleX = SCREEN_WIDTH  >> 1;				// This is a binary shift to get half the width
	int middleY = SCREEN_HEIGHT >> 1;				// This is a binary shift to get half the height
	float angleX = 0.0f;							// This is the direction for looking up or down
	float angleY = 0.0f;							// This will be the value we need to rotate around the Y axis (Left and Right)
	static float currentRotX = 0.0f;
	
	GetCursorPos(&mousePos);						
	
	if ((mousePos.x == middleX) && (mousePos.y == middleY)) 
		return;

	SetCursorPos(middleX, middleY);							

	angleX = (float)((middleX - mousePos.x)) / 1000.0f * degreeSensitivity;		
	angleY = (float)((middleY - mousePos.y)) / 1000.0f * degreeSensitivity;		
}

void CFunCamera::Look()
{
	gluLookAt(vCameraPosition.x, vCameraPosition.y, vCameraPosition.z,	
			  vCameraView.x,	 vCameraView.y,     vCameraView.z,	
			  vCameraUp.x, vCameraUp.y, vCameraUp.z);
}


void CFunCamera::UpdateRightVector()
{
	vCameraRight = Cross(vCameraView - vCameraPosition, vCameraUp);
	vCameraRight.Normalize();
}

void CFunCamera::Zoom(float speed)
{
	CVector3 vVector = vCameraView - vCameraPosition;
	vVector.Normalize();
	
	vCameraPosition.x += vVector.x * speed;		
	vCameraPosition.y += vVector.y * speed;		
	vCameraPosition.z += vVector.z * speed;		
	vCameraView.x += vVector.x * speed;		
	vCameraView.y += vVector.y * speed;		
	vCameraView.z += vVector.z * speed;	
}

void CFunCamera::ForwardBackward(float speed)
{
	CVector3 vVector = vCameraView - vCameraPosition;

	vVector.Normalize();
	
	vCameraPosition.x += vVector.x * speed;	
	vCameraPosition.y += vVector.y * speed;	
	vCameraView.x += vVector.x * speed;		
	vCameraView.y += vVector.y * speed;	
}

void CFunCamera::ChangePosition(float dx, float dy)
{
	// Add the right vector to position
	vCameraPosition.x += dx;
	vCameraPosition.y += dy;

	// Add the right vector to view
	vCameraView.x += dx;
	vCameraView.y += dy;
}

void CFunCamera::LeftRight(float speed)
{
	// Add the right vector to position
	vCameraPosition.x += vCameraRight.x * speed;
	vCameraPosition.y += vCameraRight.y * speed;

	// Add the right vector to view
	vCameraView.x += vCameraRight.x * speed;
	vCameraView.y += vCameraRight.y * speed;
}


void CFunCamera::UpDown(float speed)
{
	// Add the up vector to position
	vCameraPosition.x += vCameraUp.x * speed;
	vCameraPosition.y += vCameraUp.y * speed;
	vCameraPosition.z += vCameraUp.z * speed;

	// Add the up vector to view
	vCameraView.x += vCameraUp.x * speed;
	vCameraView.y += vCameraUp.y * speed;
	vCameraView.z += vCameraUp.z * speed;
}

void CFunCamera::RotateH(float angle, float playerPosX, float playerPosY, float distance)
{

	vCameraView.x = playerPosX;
	vCameraView.y = playerPosY;

	float cosAlpha = (float)cos(angle*PIdiv180);
	float sinAlpha = (float)sin(angle*PIdiv180);

	CVector3 vTheta;
	vTheta.x = vCameraPosition.x - playerPosX;
	vTheta.y = vCameraPosition.y - playerPosY;
	vTheta.z = 0;

	CVector3 vAlpha;

	vAlpha.x = vTheta.x * cosAlpha - vTheta.y * sinAlpha;
	vAlpha.y = vTheta.x * sinAlpha + vTheta.y * cosAlpha;
	vAlpha.z = 0; 

	vAlpha.Normalize();

	vAlpha.x *= distance;
	vAlpha.y *= distance;

	vCameraPosition.x = playerPosX + vAlpha.x;
	vCameraPosition.y = playerPosY + vAlpha.y;

	float x = vCameraUp.x;
	float y = vCameraUp.y;
	float z = vCameraUp.z;

	UpdateRightVector();
}

void CFunCamera::RotateV(float angle)
{
	float x = vCameraRight.x;
	float y = vCameraRight.y;
	float z = vCameraRight.z;

	CVector3 vView = vCameraView - vCameraPosition;		
	CVector3 vNewView = CalculateRotation(angle, x, y, z, vView);

	vCameraView = vCameraPosition + vNewView;

	vCameraUp = Cross(vCameraView - vCameraPosition, vCameraRight)*-1;
	vCameraUp.Normalize();
}

void CFunCamera::Panning(float angle)
{
	CVector3 vVector = vCameraView - vCameraPosition;

	float x = vVector.x;
	float y = vVector.y;
	float z = vVector.z;

	CVector3 vNewUp;
	CVector3 vUp = vCameraUp;

	vNewUp = CalculateRotation(angle, x, y, z, vUp);

	vCameraUp = vNewUp;
	vCameraUp.Normalize();
	UpdateRightVector();
}

void CFunCamera::Reset()
{
	PositionCamera(	vCameraPosition.x, vCameraPosition.y, vCameraPosition.z,
					vCameraPosition.x+1, vCameraPosition.y, vCameraPosition.z,
					0, 0, 1);
}

CVector3 CFunCamera::CalculateRotation(float angle, float x, float y, float z, CVector3 vRot)
{
	CVector3 vResult;

	// Calculate the sine and cosine of the angle once
	float cosTheta = (float)cos(angle*PIdiv180);
	float sinTheta = (float)sin(angle*PIdiv180);

	// Find the new x position for the new rotated point
	vResult.x  = (cosTheta + (1 - cosTheta) * x * x)		* vRot.x;
	vResult.x += ((1 - cosTheta) * x * y - z * sinTheta)	* vRot.y;
	vResult.x += ((1 - cosTheta) * x * z + y * sinTheta)	* vRot.z;

	// Find the new y position for the new rotated point
	vResult.y  = ((1 - cosTheta) * x * y + z * sinTheta)	* vRot.x;
	vResult.y += (cosTheta + (1 - cosTheta) * y * y)		* vRot.y;
	vResult.y += ((1 - cosTheta) * y * z - x * sinTheta)	* vRot.z;

	// Find the new z position for the new rotated point
	vResult.z  = ((1 - cosTheta) * x * z - y * sinTheta)	* vRot.x;
	vResult.z += ((1 - cosTheta) * y * z + x * sinTheta)	* vRot.y;
	vResult.z += (cosTheta + (1 - cosTheta) * z * z)		* vRot.z;

	return vResult;
}

void CFunCamera::TurnControlOn()
{
	if (!control)
		control = true;
}

void CFunCamera::TurnControlOff()
{
	if (control)
		control = false;
}

void CFunCamera::ApplyMatrix()
{
	GLfloat theMatrix[16];
	glGetFloatv(GL_MODELVIEW_MATRIX, theMatrix);

	glLoadIdentity();
	glMultMatrixf(theMatrix);
}
