#ifndef _GLBOMB_H
#define _GLBOMB_H

#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library
#include <gl\glut.h>

#include "glcolorpalette.h"

#define PI 3.1415926535897932384626433832795
#define PIdiv180 (PI/180.0)
#define EXPLOSIONTIME 500
#define WAITTIME 3500
#define BOMBRADIUS 0.25
#define BOMBMAXRADIUS 0.3

float bombAmbient[4] = {0.23125, 0.23125, 0.23125, 1.0};
float bombDiffuse[4] = {0.2775, 0.2775, 0.2775, 1.0};
float bombSpecular[4] = {0.773911, 0.773911, 0.773911, 1.0};
float bombEmission[4] = {0.0, 0.0, 0.0, 0.0};
float bombShine[1] = {89.6};

class CFunBomb 
{
	public:
		float posX;
		float posY;
		float birthTime;
		float igniteTime;
		bool available;
		int explosionSize;
		bool exploding;
		bool computed;

		CFunBomb()
		{
			explosionSize = 2;
			birthTime = 0;
			available = true;
			posX = -1;
			posY = -1;
			exploding = false;
			computed = false;
			currentRadius = BOMBRADIUS;
			offset = 0.02;
		}

		void IncrementSize()
		{
			if (explosionSize < 14)
				explosionSize++;
		}

		void MaximizeSize()
		{
			explosionSize = 14;
		}

		void MinimizeSize()
		{
			explosionSize = 2;
		}

		void Reset()
		{
			explosionSize = 2;
		}

		void SetBomb(float x, float y)
		{
			posX = (int)x + 0.5;
			posY = (int)y + 0.5;
			birthTime = glutGet(GLUT_ELAPSED_TIME);
			igniteTime = birthTime + WAITTIME;
			available = false;
			computed = false;
		}

		bool Render()
		{
			float currentTime = glutGet(GLUT_ELAPSED_TIME);

			currentRadius += offset;

			if (currentRadius > BOMBMAXRADIUS || currentRadius < BOMBRADIUS)
				offset *= -1;

			if (birthTime > 0 && currentTime - birthTime >= WAITTIME)
				exploding = true;

			if (!exploding && birthTime > 0 && currentTime - birthTime < WAITTIME)
			{
				glPushMatrix();

				glMaterialfv(GL_FRONT, GL_AMBIENT, bombAmbient);
				glMaterialfv(GL_FRONT, GL_DIFFUSE, bombDiffuse);
				glMaterialfv(GL_FRONT, GL_SPECULAR, bombSpecular);
				glMaterialfv(GL_FRONT, GL_EMISSION, bombEmission);
				glMaterialfv(GL_FRONT, GL_SHININESS, bombShine);

				glTranslatef(posX, posY, currentRadius);
				glColor3f(0.2, 0.2, 0.2);
				glutSolidSphere(currentRadius, 10, 10);;

				glPushMatrix();
				glTranslatef(0, 0, currentRadius - 0.03);
				glColor3f(0.5, 0.5, 0.5);
				gluCylinder(gluNewQuadric(), 0.1, 0.1, 0.1, 10, 10);
				glRotatef(-45, 0, 0, 1);
				glRotatef(20, 0, 1, 0);
				glColor3f(1.0, 1.0, 1.0);
				gluCylinder(gluNewQuadric(), 0.03, 0.03, 0.23, 10, 10);
				glPushMatrix();
				glTranslatef(0, 0, 0.23);
				glColor3ub(255, 102, 0);
				glutSolidSphere(0.038, 4, 4);
				glPopMatrix();
				glPopMatrix();
						
				glMaterialfv(GL_FRONT, GL_AMBIENT, defaultAmbient);
				glMaterialfv(GL_FRONT, GL_DIFFUSE, defaultDiffuse);
				glMaterialfv(GL_FRONT, GL_SPECULAR, defaultSpecular);
				glMaterialfv(GL_FRONT, GL_EMISSION, defaultEmission);
				glMaterialfv(GL_FRONT, GL_SHININESS, defaultShine);
			
				glPopMatrix();
				return false;	// false = not exploding
			}

			else if (exploding)
			{
				if (currentTime - igniteTime >= EXPLOSIONTIME)
				{
					birthTime = 0;
					available = true;
					exploding = false;
				}
				return true; // true = exploding

			}
			
			return false;	// not exploding
		}

	private:
		float currentRadius;
		float offset;

};


#endif
