#pragma comment(lib, "opengl32.lib")
#pragma comment(lib, "glu32.lib")

#include <time.h>

#include "main.h"										// This includes our header file
#include "glvector.h"
#include "gllight.h"
#include "glcamera.h"
#include "glmap.h"
#include "glcharacter.h"
#include "glgrid.h"
#include "glbomb.h"
#include "gldestructableobject.h"
#include "glenemy.h"
#include "glsnow.h"


#define	 VK_COMMA	0xbc
#define  VK_SEMICOLON 0xba
#define  VK_QUOTE	0xde
#define  VK_PERIOD   0xbe 
#define  VK_SLASH   0xbf 

#define PAUSETIME 2000
#define GAMETIME 360000
#define MAX_TEXTURES 62

bool  g_bFullScreen = false;								// Set full screen as default
HWND  g_hWnd;											// This is the handle for the window
RECT  g_rRect;											// This holds the window dimensions
HDC   g_hDC;											// General HDC - (handle to device context)
HGLRC g_hRC;											// General OpenGL_DC - Our Rendering Context for OpenGL
HINSTANCE g_hInstance;									// This holds the global hInstance for UnregisterClass() in DeInit()

int screenWidth = 1024;
int screenHeight = 735;
int screenPHeight = 200;

float ambientWorld[4] = {0.3, 0.3, 0.3, 0.5};
float diffuseWorld[4] = {0.5, 0.5, 0.5, 1.0};
float specularWorld[4] = {1.0, 1.0, 1.0, 1.0};

float ambientSpotLight[4] = {0.3, 0.3, 0.3, 1.0f};
float diffuseSpotLight[4] = {0.9f, 0.9f, 0.9f, 1.0f};
float specularSpotLight[4] = {0.9f, 0.9f, 0.9f, 1.0f};

long int seed = time(0);
TRanrotWGenerator rg(seed);

slScheduler soundScheduler(8000);
slSample* soundSample1;

CFunCamera g_cameraWorld;
CFunCamera g_cameraP1;
CFunCamera g_cameraP2;
CFunLight g_globalLight(GL_LIGHT0);
CFunLight g_spotLight(GL_LIGHT1);
CFunMap g_map;
CFunGrid g_grid(&rg);
CFunCharacter g_player1(1, 0.5, 0.5, 0, 1, 1, 0, &g_grid);
//CFunCharacter g_player1(1, 104.5, 100.5, 0, 1, 1, 0, colorP1, &g_grid);
CFunCharacter g_player2(2, 14.5, 0.5, 0, 1, 1, 0, &g_grid);
CFunEnemy g_enemy1(1, &g_grid);
CFunEnemy g_enemy2(2, &g_grid);
CFunEnemy g_enemy3(3, &g_grid);
CFunEnemy g_enemy4(4, &g_grid);
CFunSnow g_snow;
float theSeason;

float dirN1 = 0.0;
float dirS1 = 180.0;
float dirW1 = 90.0;
float dirE1 = -90.0;

float dirN2 = 0.0;
float dirS2 = 180.0;
float dirW2 = 90.0;
float dirE2 = -90.0;

float now = 0;

bool debugItems = false;
bool debugCells = false;

float initialGameTime = 0;
bool gameDone = false;

bool startGame = false;
bool shadow = false;
CFunCamera g_cameraMenu;
RECT clientRect;
WINDOWPLACEMENT windowPlace;
POINT mousePos;
POINT origin;
float cursorX;
float cursorY;
int menuState = 0;

float floorShadow[4][4];								// Matrix used to calculate our projected floor shadow
float groundplane[]   = {0.0, 0.0, 1.0, 1.0};		// Normal of the floor
float lightPos[4] = {7.5, 7.5, 10, 1.0};

UINT textures[MAX_TEXTURES];							// Textures variable

WPARAM MainLoop()
{
	MSG msg;

	while(1)											// Do our infinate loop
	{
		// Check if there was a message
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) 
        { 
			if(msg.message == WM_QUIT)					// If the message wasnt to quit
				break;
            TranslateMessage(&msg);						// Find out what the message does
            DispatchMessage(&msg);						// Execute the message
        }
		else											// if there wasn't a message
		{ 
			if (startGame)
			{
				ProcessKeys();
				ViewAll();								// Render the scene every frame so it calculates the frame rate
				soundScheduler.update();
			}
			else
			{
				ProcessMouse(msg);
				ViewMenu();
			}
		} 
	}

	return(msg.wParam);									// Return from the program
}
 

void CreateTexture(UINT textureArray[], LPSTR strFileName, int textureID)
{
	AUX_RGBImageRec *pBitmap = NULL;
	
	if(!strFileName)									// Return from the function if no file name was passed in
		return;
	
	pBitmap = auxDIBImageLoad(strFileName);				// Load the bitmap and store the data
	
	if(pBitmap == NULL)									// If we can't load the file, quit!
		exit(0);

	// Generate a texture with the associative texture ID stored in the array
	glGenTextures(1, &textureArray[textureID]);

	// Bind the texture to the texture arrays index and init the texture
	glBindTexture(GL_TEXTURE_2D, textureArray[textureID]);

	// Build Mipmaps (builds different versions of the picture for distances - looks better)
	gluBuild2DMipmaps(GL_TEXTURE_2D, 3, pBitmap->sizeX, pBitmap->sizeY, GL_RGB, GL_UNSIGNED_BYTE, pBitmap->data);

	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_NEAREST);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR_MIPMAP_LINEAR);


	// Now we need to free the bitmap data that we loaded since openGL stored it as a texture

	if (pBitmap)										// If we loaded the bitmap
	{
		if (pBitmap->data)								// If there is texture data
		{
			free(pBitmap->data);						// Free the texture data, we don't need it anymore
		}

		free(pBitmap);									// Free the bitmap structure
	}
}

void InitializeOpenGL(int width, int height) 
{  
    g_hDC = GetDC(g_hWnd);								// This sets our global HDC
														// We don't free this hdc until the end of our program
    if (!bSetupPixelFormat(g_hDC))						// This sets our pixel format/information
        PostQuitMessage (0);							// If there's an error, quit

    g_hRC = wglCreateContext(g_hDC);					// This creates a rendering context from our hdc
    wglMakeCurrent(g_hDC, g_hRC);						// This makes the rendering context we just created the one we want to use

	glClearColor(0, 0, 0, 1);
	glEnable(GL_DEPTH_TEST);							// Enables Depth Testing
	glEnable(GL_COLOR_MATERIAL);							// Allow color to show during lighting

	glEnable(GL_NORMALIZE);
	
	glShadeModel(GL_SMOOTH);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST);	// Really Nice Perspective Calculations
	glHint(GL_POINT_SMOOTH_HINT,GL_NICEST);				// Really Nice Point Smoothing

	glEnable(GL_LIGHTING);								// This turns on lighting

	SizeOpenGLScreen(width, height);					// Setup the screen translations and viewport
}

void InitializeObjects()
{
	CreateTexture(textures, "textures/spring_summer_ground.bmp", 0);
	CreateTexture(textures, "textures/sprSum_aut_ground20.bmp", 1);
	CreateTexture(textures, "textures/sprSum_aut_ground40.bmp", 2);
	CreateTexture(textures, "textures/sprSum_aut_ground60.bmp", 3);
	CreateTexture(textures, "textures/sprSum_aut_ground80.bmp", 4);
	CreateTexture(textures, "textures/autumn_ground.bmp", 5);
	CreateTexture(textures, "textures/aut_wint_ground20.bmp", 6);
	CreateTexture(textures, "textures/aut_wint_ground40.bmp", 7);
	CreateTexture(textures, "textures/aut_wint_ground60.bmp", 8);
	CreateTexture(textures, "textures/aut_wint_ground80.bmp", 9);
	CreateTexture(textures, "textures/winter_ground.bmp", 10);
	CreateTexture(textures, "textures/wint_sprSum_ground20.bmp", 11);
	CreateTexture(textures, "textures/wint_sprSum_ground40.bmp", 12);
	CreateTexture(textures, "textures/wint_sprSum_ground60.bmp", 13);
	CreateTexture(textures, "textures/wint_sprSum_ground80.bmp", 14);

	CreateTexture(textures, "textures/spring_summer_background.bmp", 15);
	CreateTexture(textures, "textures/sprSum_aut_back20.bmp", 16);
	CreateTexture(textures, "textures/sprSum_aut_back40.bmp", 17);
	CreateTexture(textures, "textures/sprSum_aut_back60.bmp", 18);
	CreateTexture(textures, "textures/sprSum_aut_back80.bmp", 19);
	CreateTexture(textures, "textures/autumn_background.bmp", 20);
	CreateTexture(textures, "textures/aut_wint_back20.bmp", 21);
	CreateTexture(textures, "textures/aut_wint_back40.bmp", 22);
	CreateTexture(textures, "textures/aut_wint_back60.bmp", 23);
	CreateTexture(textures, "textures/aut_wint_back80.bmp", 24);
	CreateTexture(textures, "textures/winter_background.bmp", 25);
	CreateTexture(textures, "textures/wint_sprSum_back20.bmp", 26);
	CreateTexture(textures, "textures/wint_sprSum_back40.bmp", 27);
	CreateTexture(textures, "textures/wint_sprSum_back60.bmp", 28);
	CreateTexture(textures, "textures/wint_sprSum_back80.bmp", 29);

	CreateTexture(textures, "textures/spring_summer_orthogonal.bmp", 30);
	CreateTexture(textures, "textures/sprSum_aut_orth20.bmp", 31);
	CreateTexture(textures, "textures/sprSum_aut_orth40.bmp", 32);
	CreateTexture(textures, "textures/sprSum_aut_orth60.bmp", 33);
	CreateTexture(textures, "textures/sprSum_aut_orth80.bmp", 34);
	CreateTexture(textures, "textures/autumn_orthogonal.bmp", 35);
	CreateTexture(textures, "textures/aut_wint_orth20.bmp", 36);
	CreateTexture(textures, "textures/aut_wint_orth40.bmp", 37);
	CreateTexture(textures, "textures/aut_wint_orth60.bmp", 38);
	CreateTexture(textures, "textures/aut_wint_orth80.bmp", 39);
	CreateTexture(textures, "textures/winter_orthogonal.bmp", 40);
	CreateTexture(textures, "textures/wint_sprSum_orth20.bmp", 41);
	CreateTexture(textures, "textures/wint_sprSum_orth40.bmp", 42);
	CreateTexture(textures, "textures/wint_sprSum_orth60.bmp", 43);
	CreateTexture(textures, "textures/wint_sprSum_orth80.bmp", 44);

	CreateTexture(textures, "textures/tile_road.bmp", 45);			// Load textures, white.bmp currently not used
	CreateTexture(textures, "textures/tile_road_v.bmp", 46);			// Load textures, white.bmp currently not used
	CreateTexture(textures, "textures/particle.bmp", 47);
	CreateTexture(textures, "textures/particle_cloud.bmp", 48);
	CreateTexture(textures, "textures/cheese.bmp", 49);

	CreateTexture(textures, "textures/item_bomb.bmp", 50);
	CreateTexture(textures, "textures/item_speed.bmp", 51);
	CreateTexture(textures, "textures/item_fire.bmp", 52);
	CreateTexture(textures, "textures/item_maxfire.bmp", 53);
	CreateTexture(textures, "textures/item_wall.bmp", 54);
	CreateTexture(textures, "textures/item_trap.bmp", 55);
	CreateTexture(textures, "textures/wall_top.bmp", 56);
	CreateTexture(textures, "textures/wall_side.bmp", 57);
	CreateTexture(textures, "textures/maze_wall.bmp", 58);
	CreateTexture(textures, "textures/maze_wall_inside.bmp", 59);

	CreateTexture(textures, "textures/help.bmp", 60);
	CreateTexture(textures, "textures/menu.bmp", 61);

	soundScheduler.setSafetyMargin(0.128f);	
	soundSample1 = new slSample("sounds/reefer_c1.wav", &soundScheduler);
	soundScheduler.loopSample(soundSample1);

	//world camera position
	g_cameraWorld.PositionCamera(7.5, -5.7625, 8.541,	7.5, 6.6575, -0.855,	0, 0.937, 0.342);  

	//maze camera positin
	//g_cameraWorld.PositionCamera(105.5, 95.7625, 8.541,	105.5, 106.6575, -0.855,	0, 0.937, 0.342);  

	g_cameraP1.PositionCamera(0.5, -1.5, 0.9,	0.5, 0.5, 0.7,	0, 0, 1);
	g_cameraP1.SetType(1);
	g_cameraP2.PositionCamera(14.5, -1.5, 0.9,	14.5, 0.5, 0.7,	0, 0, 1);
	g_cameraP2.SetType(2);

	g_globalLight.SetIntensities(ambientWorld, diffuseWorld, specularWorld);
	g_globalLight.SetPosition(7.5, 7.5, 1, false);

	g_spotLight.SetIntensities(ambientSpotLight, diffuseSpotLight, specularSpotLight);
	g_spotLight.SetPosition(0, 0, 1, true);
	g_spotLight.SetSpotParams(0, 0, -1, 10.0, 2.0);

	g_cameraMenu.PositionCamera(0, 0, 10, 0, 0, 0, 0, 1, 0);

	g_grid.InitTextures(textures, 47, 49, 50, 56, 58);
	g_grid.InitWalls();
	g_grid.InitMaze();
	g_grid.InitParticles();
	g_grid.InitCarsAndObjects();

	g_enemy1.SetRandomPosition();
	g_enemy2.SetRandomPosition();
	g_enemy3.SetRandomPosition();
	g_enemy4.SetRandomPosition();

	g_player1.CreateDL();
	g_player1.InitSounds(&soundScheduler);
	g_player2.CreateDL();
	g_player2.InitSounds(&soundScheduler);

	g_enemy1.CreateDL();
	g_enemy2.CreateDL();
	g_enemy3.CreateDL();
	g_enemy4.CreateDL();

	g_map.CreateDL(textures, 45, 46, 0, 5, 10, 15, 20, 25, 30, 35, 40);
	g_snow.Initialize(&rg, textures, 48);
}

void ViewWorld()
{
	glScissor(0, screenPHeight, screenWidth, screenHeight - screenPHeight);
	glViewport(0, screenPHeight, screenWidth, screenHeight - screenPHeight);	

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(45.0f, ((GLfloat)screenWidth)/((GLfloat)screenHeight - screenPHeight), 1.0, 150.0f);

	glMatrixMode(GL_MODELVIEW);	

	glLoadIdentity();
	g_globalLight.TurnOn();

	g_cameraWorld.Look();

	RenderText();
	RenderWorldScene();
	g_globalLight.TurnOff();
}


void ViewP1()
{
	glScissor(0, 0, screenWidth/2, screenPHeight);
	glViewport(0, 0, screenWidth/2, screenPHeight);	

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(45.0f, ((GLfloat)screenWidth/2)/(GLfloat)screenPHeight, 0.5, 150.0f);

	glMatrixMode(GL_MODELVIEW);	
	glLoadIdentity();

	if (g_grid.player1InMaze)
		g_spotLight.TurnOn();
	else
		g_globalLight.TurnOn();

	g_cameraP1.Look();

	RenderP1Scene();
	
	if (g_grid.player1InMaze)
		g_spotLight.TurnOff();
	else
		g_globalLight.TurnOff();
}


void ViewP2()
{
	glScissor(screenWidth/2, 0, screenWidth/2, screenPHeight);
	glViewport(screenWidth/2, 0, screenWidth/2, screenPHeight);	

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(45.0f, ((GLfloat)screenWidth/2)/(GLfloat)screenPHeight, 0.5, 150.0f);

	glMatrixMode(GL_MODELVIEW);	
	glLoadIdentity();

	if (g_grid.player2InMaze)
		g_spotLight.TurnOn();
	else
		g_globalLight.TurnOn();

	g_cameraP2.Look();

	RenderP2Scene();

	if (g_grid.player2InMaze)
		g_spotLight.TurnOff();
	else
		g_globalLight.TurnOff();	
}

void ViewAll() 
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	ViewWorld();
	ViewP1();
	ViewP2();
	SwapBuffers(g_hDC);
}

void ViewMenu()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	glViewport(0, 0, screenWidth, screenHeight);	

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(45.0f, ((GLfloat)screenWidth)/((GLfloat)screenHeight), 1.0, 150.0f);

	glMatrixMode(GL_MODELVIEW);	

	glLoadIdentity();

	g_globalLight.TurnOn();	
	g_cameraMenu.Look();
	RenderMenu();	
	g_globalLight.TurnOff();


	SwapBuffers(g_hDC);
}

void RenderMenuText()
{
	char s[50];

	glColor3f(0.0f,1.0f,1.0f);
	SetOrthographicProjection();
	glPushMatrix();
	glLoadIdentity();

	sprintf(s, "mouseX : %f  mouseY: %f", cursorX, cursorY); 
	RenderBitmapString(30, 30, s);

	glPopMatrix();
	ResetPerspectiveProjection();
}

void RenderMenu()
{
	if (menuState == 0)
	{
		glEnable(GL_TEXTURE_2D);							// Enable Texture Mapping
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[61]);

		glBegin(GL_QUADS);

		glNormal3f(0, 0, 1);
		glTexCoord2f(0, 1);
		glVertex3f(-5.9, 4.3, 0);

		glTexCoord2f(1, 1);
		glVertex3f(5.9, 4.3, 0);

		glTexCoord2f(1, 0);
		glVertex3f(5.9, -4.3, 0);

		glTexCoord2f(0, 0);
		glVertex3f(-5.9, -4.3, 0);

		glEnd();

		glDisable(GL_TEXTURE_2D);
	}

	else if (menuState == 1)
	{

		glEnable(GL_TEXTURE_2D);							// Enable Texture Mapping
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glBindTexture(GL_TEXTURE_2D, textures[60]);

		glBegin(GL_QUADS);

		glNormal3f(0, 0, 1);
		glTexCoord2f(0, 1);
		glVertex3f(-5.8, 4.2, 0);

		glTexCoord2f(1, 1);
		glVertex3f(5.8, 4.2, 0);

		glTexCoord2f(1, 0);
		glVertex3f(5.8, -4.2, 0);

		glTexCoord2f(0, 0);
		glVertex3f(-5.8, -4.2, 0);

		glEnd();

		glDisable(GL_TEXTURE_2D);
	}

	glColor3f(0.5, 0.5, 0.5);
	glPushMatrix();
	glBegin(GL_TRIANGLES);
	glVertex3f((float)cursorX, (float)cursorY, 0.1);
	glVertex3f((float)cursorX-0.1, (float)cursorY-0.2, 0.1);
	glVertex3f((float)cursorX, (float)cursorY-0.17, 0.1);
	glVertex3f((float)cursorX, (float)cursorY, 0.1);
	glVertex3f((float)cursorX+0.1, (float)cursorY-0.2, 0.1);
	glVertex3f((float)cursorX, (float)cursorY-0.17, 0.1);
	glEnd();
	glPopMatrix();
}


void RenderBitmapString(float x, float y, char *string)
{
	int font=(int)GLUT_BITMAP_8_BY_13;

	char *c;
	glRasterPos2f(x, y);
	for (c = string; *c != '\0'; c++) 
		glutBitmapCharacter((GLvoid*)font, *c);
}

void RenderBiggerBitmapString(float x, float y, char *string)
{
	int font=(int)GLUT_BITMAP_9_BY_15;

	char *c;
	glRasterPos2f(x, y);
	for (c = string; *c != '\0'; c++) 
		glutBitmapCharacter((GLvoid*)font, *c);
}

void SetOrthographicProjection() {

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(0, screenWidth, 0, screenHeight - screenPHeight);
	glScalef(1, -1, 1);
	glTranslatef(0, -(screenHeight - screenPHeight), 0);
	glMatrixMode(GL_MODELVIEW);
}

void ResetPerspectiveProjection() {
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
}

void ShadowMatrix(float shadowMat[4][4], float groundPlane[4], float lightPos[4])
{
	float dot = groundPlane[0] * lightPos[0] + groundPlane[1] * lightPos[1] + groundPlane[2] * lightPos[2] + groundPlane[3] * lightPos[3];

	shadowMat[0][0] = dot - lightPos[0] * groundPlane[0];
	shadowMat[1][0] = 0.0 - lightPos[0] * groundPlane[1];
	shadowMat[2][0] = 0.0 - lightPos[0] * groundPlane[2];
	shadowMat[3][0] = 0.0 - lightPos[0] * groundPlane[3];

	shadowMat[0][1] = 0.0 - lightPos[1] * groundPlane[0];
	shadowMat[1][1] = dot - lightPos[1] * groundPlane[1];
	shadowMat[2][1] = 0.0 - lightPos[1] * groundPlane[2];
	shadowMat[3][1] = 0.0 - lightPos[1] * groundPlane[3];

	shadowMat[0][2] = 0.0 - lightPos[2] * groundPlane[0];
	shadowMat[1][2] = 0.0 - lightPos[2] * groundPlane[1];
	shadowMat[2][2] = dot - lightPos[2] * groundPlane[2];
	shadowMat[3][2] = 0.0 - lightPos[2] * groundPlane[3];

	shadowMat[0][3] = 0.0 - lightPos[3] * groundPlane[0];
	shadowMat[1][3] = 0.0 - lightPos[3] * groundPlane[1];
	shadowMat[2][3] = 0.0 - lightPos[3] * groundPlane[2];
	shadowMat[3][3] = dot - lightPos[3] * groundPlane[3];

}

void RenderShadow()
{

	glColorMask(GL_FALSE, GL_FALSE, GL_FALSE, GL_FALSE);
	glDepthMask(GL_FALSE);
	glEnable(GL_STENCIL_TEST);

	glStencilFunc(GL_ALWAYS, 1, 0xFFFFFFFF);
	glStencilOp(GL_REPLACE, GL_REPLACE, GL_REPLACE);

	g_map.RenderWorldFloor(0.01);

	glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
	glDepthMask(GL_TRUE);

	glStencilFunc(GL_EQUAL, 1, 0xFFFFFFFF);
	glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);

	g_map.RenderWorldFloor(0.01);

	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);

	ShadowMatrix(floorShadow, groundplane, lightPos);
	
	glPushMatrix();
	glTranslatef((lightPos[0] - g_player1.posX) * 0.1, (lightPos[1] - g_player1.posY) * 0.1, lightPos[2] * 0.1);
	glStencilOp(GL_KEEP, GL_KEEP, GL_INCR);
	glMultMatrixf((float *)floorShadow);
	g_player1.Render(true);
	glPopMatrix();

	glPushMatrix();
	glTranslatef((lightPos[0] - g_player2.posX) * 0.1, (lightPos[1] - g_player2.posY) * 0.1, lightPos[2] * 0.1);
	glStencilOp(GL_KEEP, GL_KEEP, GL_INCR);
	glMultMatrixf((float *)floorShadow);
	g_player2.Render(true);
	glPopMatrix();

	glPushMatrix();
	glTranslatef((lightPos[0] - g_enemy1.posX) * 0.1, (lightPos[1] - g_enemy1.posY) * 0.1, lightPos[2] * 0.1);
	glStencilOp(GL_KEEP, GL_KEEP, GL_INCR);
	glMultMatrixf((float *)floorShadow);
	g_enemy1.Render(true);
	glPopMatrix();

	glPushMatrix();
	glTranslatef((lightPos[0] - g_enemy2.posX) * 0.1, (lightPos[1] - g_enemy2.posY) * 0.1, lightPos[2] * 0.1);
	glStencilOp(GL_KEEP, GL_KEEP, GL_INCR);
	glMultMatrixf((float *)floorShadow);
	g_enemy2.Render(true);
	glPopMatrix();

	glPushMatrix();
	glTranslatef((lightPos[0] - g_enemy3.posX) * 0.1, (lightPos[1] - g_enemy3.posY) * 0.1, lightPos[2] * 0.1);
	glStencilOp(GL_KEEP, GL_KEEP, GL_INCR);
	glMultMatrixf((float *)floorShadow);
	g_enemy3.Render(true);
	glPopMatrix();
	
	glPushMatrix();
	glTranslatef((lightPos[0] - g_enemy4.posX) * 0.1, (lightPos[1] - g_enemy4.posY) * 0.1, lightPos[2] * 0.1);
	glStencilOp(GL_KEEP, GL_KEEP, GL_INCR);
	glMultMatrixf((float *)floorShadow);
	g_enemy4.Render(true);
	glPopMatrix();

	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LIGHTING);
	glDisable(GL_STENCIL_TEST);
}

void RenderWorldScene()
{
	now = glutGet(GLUT_ELAPSED_TIME) - initialGameTime;
	theSeason = now / (GAMETIME);

	if (!gameDone)
		CheckPlayerKilled();
	if (shadow)
		RenderShadow();

	//g_grid.RenderCarsAndItemsPlayerView(g_player1.posX, g_player1.posY, g_player1.dirX, g_player1.dirY);
	//g_map.RenderPlayerViewFloor(g_player1.posX, g_player1.posY, g_player1.dirX, g_player1.dirY);

	g_map.RenderWorldObjects();
	g_map.RenderWorldFloor(theSeason);
	g_grid.RenderCarsAndItems();

	g_snow.Render(theSeason);

	g_player1.Render(false);
	g_player2.Render(false);
	g_enemy1.Render(false);
	g_enemy2.Render(false);
	g_enemy3.Render(false);
	g_enemy4.Render(false);

}

void RenderP1Scene()
{
	g_player1.Render(false);
	if (g_grid.player1InMaze)
	{
		g_grid.RenderMaze();
		if (g_grid.player2InMaze)
			g_player2.Render(false);
	}
	else
	{
		g_map.RenderPlayerViewFloor(g_player1.posX, g_player1.posY, g_player1.dirX, g_player1.dirY);
		g_grid.RenderCarsAndItemsPlayerView(g_player1.posX, g_player1.posY, g_player1.dirX, g_player1.dirY);
		g_snow.Render(theSeason);
		g_enemy1.Render(false);
		g_enemy2.Render(false);
		g_enemy3.Render(false);
		g_enemy4.Render(false);
		if (!g_grid.player2InMaze)
			g_player2.Render(false);
	}
}

void RenderP2Scene()
{
	g_player2.Render(false);
	if (g_grid.player2InMaze)
	{
		g_grid.RenderMaze();
		if (g_grid.player1InMaze)
			g_player1.Render(false);
	}
	else
	{
		g_map.RenderPlayerViewFloor(g_player2.posX, g_player2.posY, g_player2.dirX, g_player2.dirY);
		g_grid.RenderCarsAndItemsPlayerView(g_player2.posX, g_player2.posY, g_player2.dirX, g_player2.dirY);
		g_snow.Render(theSeason);
		g_enemy1.Render(false);
		g_enemy2.Render(false);
		g_enemy3.Render(false);
		g_enemy4.Render(false);
		if (!g_grid.player1InMaze)
			g_player1.Render(false);
	}
}

void RenderLights()
{
	g_cameraWorld.ApplyMatrix();
	g_globalLight.ApplyVectors();
}

void RenderText()
{
	char s[50];
	now = glutGet(GLUT_ELAPSED_TIME) - initialGameTime;
	int min = GAMETIME / (60 * 1000) - (now / 60000);
	int sec = (int)(60 - ((now - 60000 * (int)(now / 60000)) / 1000)) % 60;

	if (min == 0 && sec == 0)
		gameDone = true;

	glColor3f(0, 0, 0);
	SetOrthographicProjection();
	glPushMatrix();
	glLoadIdentity();

	if (gameDone)
	{	
		min = 0;
		sec = 0;
	}

	if (sec < 10)
		sprintf(s, "TIME: %d:0%d", min, sec);
	else
		sprintf(s, "TIME: %d:%d", min, sec);
	RenderBitmapString(470, 30, s);


	if (gameDone)
	{
		if (g_player1.numPoints > g_player2.numPoints)
			sprintf(s, "PLAYER 1 WINS!!");
		else if (g_player2.numPoints > g_player1.numPoints)
			sprintf(s, "PLAYER 2 WINS!!");
		else
			sprintf(s, "  ROUND DRAW!");
		RenderBiggerBitmapString(440, 250, s);
	}

	sprintf(s, "Bombs : %d", g_player1.numBombItemsTaken + 1); 
	RenderBitmapString(30, 30, s);
	if (g_player1.numMaxFireItemsTaken > 0)
		sprintf(s, "Fire  : MAX");
	else
		sprintf(s, "Fire  : %d", g_player1.numFireItemsTaken + 2); 
	RenderBitmapString(30, 45, s);
	sprintf(s, "Speed : %d", g_player1.numSpeedItemsTaken); 
	RenderBitmapString(30, 60, s);
	sprintf(s, "Walls : %d", g_player1.numWallItemsTaken); 
	RenderBitmapString(30, 75, s);
	sprintf(s, "Traps : %d", g_player1.numTrapItemsTaken); 
	RenderBitmapString(30, 90, s);
	sprintf(s, "Cheese: %d", g_player1.numCheeseItemsTaken); 
	RenderBitmapString(30, 105, s);
	sprintf(s, "Points: %d", g_player1.numPoints); 
	RenderBitmapString(30, 120, s);

	sprintf(s, "Bombs : %d", g_player2.numBombItemsTaken + 1); 
	RenderBitmapString(930, 30, s);
	if (g_player2.numMaxFireItemsTaken > 0)
		sprintf(s, "Fire  : MAX");
	else
		sprintf(s, "Fire  : %d", g_player2.numFireItemsTaken + 2); 
	RenderBitmapString(930, 45, s);
	//sprintf(s, "Speed: %d", (int)((g_player2.speed - INITIALSPEED)/0.025)); 
	sprintf(s, "Speed : %d", g_player2.numSpeedItemsTaken); 
	RenderBitmapString(930, 60, s);
	sprintf(s, "Walls : %d", g_player2.numWallItemsTaken); 
	RenderBitmapString(930, 75, s);
	sprintf(s, "Traps : %d", g_player2.numTrapItemsTaken); 
	RenderBitmapString(930, 90, s);
	sprintf(s, "Cheese: %d", g_player2.numCheeseItemsTaken); 
	RenderBitmapString(930, 105, s);
	sprintf(s, "Points: %d", g_player2.numPoints); 
	RenderBitmapString(930, 120, s);

	
	if (debugItems)
	{
		
//sprintf(s, "P1 pos(%f, %f)  gridP1(%f, %f)  dx: %f  dy:%f", g_player1.posX, g_player1.posY, g_grid.player1X, g_grid.player1Y, g_player1.dX, g_player1.dY);)
		RenderBitmapString(30, 170, g_player1.collisionType);
		RenderBitmapString(30, 200, g_player2.collisionType);
//		CFunItem** theItems = g_grid.getItems();
//		for (int i = 90; i < 93; i++)
//		{
//			sprintf(s, "Item[%d] type:%d taken: %d x:%d y:%d", i, theItems[i]->type, theItems[i]->taken, (int) theItems[i]->posX, (int) theItems[i]->posY);
//			if (i <= 25)
//				RenderBitmapString(30, 120 + ((i - 90) * 15), s);
//			else
//				renderBitmapString(630, 120 + ((i-25) * 15), s);
//		}
/*
		sprintf(s, "posX:%f  posY:%f", g_enemy1.posX, g_enemy1.posY);
		renderBitmapString(630, 300, s);
		sprintf(s, "posX:%f  posY:%f", g_enemy2.posX, g_enemy2.posY);
		renderBitmapString(630, 330, s);
		sprintf(s, "posX:%f  posY:%f", g_enemy3.posX, g_enemy3.posY);
		renderBitmapString(630, 360, s);
		sprintf(s, "posX:%f  posY:%f", g_enemy4.posX, g_enemy4.posY);
		renderBitmapString(630, 390, s);

		sprintf(s, "posX:%f  posY:%f", g_grid.enemiesX[0], g_grid.enemiesY[0]);
		renderBitmapString(630, 315, s);
		sprintf(s, "posX:%f  posY:%f", g_grid.enemiesX[1], g_grid.enemiesY[1]);
		renderBitmapString(630, 345, s);
		sprintf(s, "posX:%f  posY:%f", g_grid.enemiesX[2], g_grid.enemiesY[2]);
		renderBitmapString(630, 375, s);
		sprintf(s, "posX:%f  posY:%f", g_grid.enemiesX[3], g_grid.enemiesY[3]);
		renderBitmapString(630, 405, s);
*/
	}

	if (debugCells)
	{
		CFunCell*** theMatrix = g_grid.getMatrix();
		CFunItem* theItem;

		int count = 0;

		for (int x = 0; x < 15; x++)
		{			
			for (int y = 0; y < 15; y++)
			{
				theItem = theMatrix[x][y]->item;
				
				if (theItem != NULL)
				{
					sprintf(s, "matrix[%d][%d] -- type:%d taken: %d x:%d y:%d", x, y, theItem->type, theItem->taken, (int) theItem->posX, (int) theItem->posY);

					if (count <= 25)
						RenderBitmapString(30, 120 + (count * 15), s);
					else
						RenderBitmapString(630, 120 + ((count-25) * 15), s);

					count++;
				}
			}
		}
	}


	glPopMatrix();
	ResetPerspectiveProjection();
}

void CheckPlayerKilled()
{
	if (g_grid.player1Killed)
	{
		g_player1.PlayerKilled();
		g_cameraP1.PositionCamera(0.5, -1.5, 0.9,	0.5, 0.5, 0.7,	0, 0, 1);
		g_grid.ClearPlayerKilledFlag(1);
		dirN1 = 0;
		dirS1 = 180;
		dirW1 = 90;
		dirE1 = -90;
	}
	else if (g_grid.player2Killed)
	{
		g_player2.PlayerKilled();
		g_cameraP2.PositionCamera(14.5, -1.5, 0.9,	14.5, 0.5, 0.7,	0, 0, 1);
		g_grid.ClearPlayerKilledFlag(2);
		dirN2 = 0;
		dirS2 = 180;
		dirW2 = 90;
		dirE2 = -90;
	}
}

void ComputeOrigin(POINT* pOrigin)
{
	int border = (windowPlace.rcNormalPosition.right - windowPlace.rcNormalPosition.left - clientRect.right) / 2;
	int titlebar = windowPlace.rcNormalPosition.bottom - windowPlace.rcNormalPosition.top - clientRect.bottom - border;

	pOrigin->x = windowPlace.rcNormalPosition.left + border + clientRect.right/2;
	pOrigin->y = windowPlace.rcNormalPosition.top + titlebar + clientRect.bottom/2;
}

void ProcessMouse(MSG msg)
{				
	GetClientRect(g_hWnd, &clientRect);
	GetWindowPlacement(g_hWnd, &windowPlace);
	ComputeOrigin(&origin);

	GetCursorPos(&mousePos);

	cursorX = (float)(mousePos.x - origin.x) / (clientRect.right / 11.5);
	cursorY = (float)(origin.y - mousePos.y) / (clientRect.bottom / 8.3);

	if (cursorX < 6.75 && cursorX > -6.75 && cursorY < 4.15 && cursorY > -4.15)
		ShowCursor(false);
	else
		ShowCursor(true);

	if (menuState == 0)
	{
		if (msg.message == WM_LBUTTONDOWN)
		{ 
			if (cursorX > -1.98 && cursorX < 1.70 && cursorY > -0.85 && cursorY < -0.09)
				startGame = true;
			else if (cursorX > -0.99 && cursorX < 0.71 && cursorY > -2.2 && cursorY < -1.5)
				menuState = 1;
		}
	}
	else if (menuState == 1)
	{
		if (msg.message == WM_LBUTTONDOWN && (cursorX > 3.96 && cursorX < 5.41 && cursorY > -3.74 && cursorY < -3.20))
			menuState = 0;
	}
}

void ProcessKeys()
{
	now = glutGet(GLUT_ELAPSED_TIME);

	if (gameDone)
		return;
/*
	if (GetKeyState('6') & 0x80)
	{
		g_grid.EnemyKillsPlayers(6, 9);
		g_grid.EnemyKillsPlayers(7, 8);
		g_grid.EnemyKillsPlayers(7, 10);
		g_grid.EnemyKillsPlayers(8, 9);
	}

	if (GetKeyState('8') & 0x80) 
	{
		debugItems = !debugItems;
	}

	if (GetKeyState('7') & 0x80) 
	{
		debugCells = !debugCells;
	}
*/

	if (GetKeyState('R') & 0x80) 
	{
		if (!g_grid.player1InMaze && (g_player1.outOfMazeTime < 0 || now - g_player1.outOfMazeTime > PAUSETIME))
		{
			g_cameraP1.RotateH(dirN1, g_player1.posX, g_player1.posY, 2.0);
			g_player1.Rotate(g_cameraP1.View() - g_cameraP1.Position(), g_cameraP1.Right());

			if (!g_player1.ForwardBackward())
			{
				dirN1 = 0;
				dirS1 = 180;
				dirW1 = 90;
				dirE1 = -90;

				if (g_player1.posX > 100)
				{
					g_cameraP1.PositionCamera(g_player1.posX + g_player1.dX, g_player1.posY + g_player1.dY, 0.9, g_player1.posX, g_player1.posY, 0.85, 0, 0, 1);
					g_grid.player1InMaze = true;
				}
				else
					g_cameraP1.PositionCamera(g_player1.posX + g_player1.dX, g_player1.posY + g_player1.dY, 0.9, g_player1.posX, g_player1.posY, 0.7, 0, 0, 1);
			}
			else
			{
				g_grid.Update(g_player1.posX, g_player1.posY, 1);
				g_cameraP1.ChangePosition(g_player1.dX, g_player1.dY);

				dirS1 = 180;
				dirN1 = 0;
				dirW1 = 90;
				dirE1 = -90;
			}
		}
		else if (g_grid.player1InMaze)
		{
			if (g_player1.ForwardBackwardMaze(1))
			{
				g_cameraP1.ChangePosition(g_player1.dX, g_player1.dY);
			}
			else
			{
				if (g_player1.posX == 7.5 && g_player1.posY == 8.5)
				{
					dirN1 = 180;
					dirS1 = 0;
					dirW1 = -90;
					dirE1 = 90;
				}
				else if (g_player1.posX == 7.5 && g_player1.posY == 10.5)
				{
					dirN1 = 0;
					dirS1 = 180;
					dirW1 = 90;
					dirE1 = -90;
				}
				else if (g_player1.posX == 6.5 && g_player1.posY == 9.5)
				{
					dirE1 = 180;
					dirW1 = 0;
					dirN1 = -90;
					dirS1 = 90;
				}
				else if (g_player1.posX == 8.5 && g_player1.posY == 9.5)
				{
					dirW1 = 180;
					dirE1 = 0;
					dirN1 = 90;
					dirS1 = -90;
				}
				g_cameraP1.PositionCamera(g_player1.posX + g_player1.dX, g_player1.posY + g_player1.dY, 0.9, g_player1.posX, g_player1.posY, 0.7, 0, 0, 1);
				g_grid.player1InMaze = false;
			}
			g_grid.Update(g_player1.posX, g_player1.posY, 1);
		}
		else
		{
			g_grid.Update(g_player1.posX, g_player1.posY, 1);
		}
	}

	if (GetKeyState('F') & 0x80) 
	{
		if (!g_grid.player1InMaze && (g_player1.outOfMazeTime < 0 || now - g_player1.outOfMazeTime > PAUSETIME))
		{
			g_cameraP1.RotateH(dirS1, g_player1.posX, g_player1.posY, 2.0);
			g_player1.Rotate(g_cameraP1.View() - g_cameraP1.Position(), g_cameraP1.Right());

			if (!g_player1.ForwardBackward())
			{
				dirN1 = 0;
				dirS1 = 180;
				dirW1 = 90;
				dirE1 = -90;
				
				if (g_player1.posX > 100)
				{
					g_cameraP1.PositionCamera(g_player1.posX + g_player1.dX, g_player1.posY + g_player1.dY, 0.9, g_player1.posX, g_player1.posY, 0.85, 0, 0, 1);
					g_grid.player1InMaze = true;
				}
				else
					g_cameraP1.PositionCamera(g_player1.posX + g_player1.dX, g_player1.posY + g_player1.dY, 0.9, g_player1.posX, g_player1.posY, 0.7, 0, 0, 1);
			}
			else
			{
				g_grid.Update(g_player1.posX, g_player1.posY, 1);
				g_cameraP1.ChangePosition(g_player1.dX, g_player1.dY);

				dirN1 = 180;
				dirS1 = 0;
				dirW1 = -90;
				dirE1 = 90;
			}
		}
		else if (g_grid.player1InMaze)
		{
			if (g_player1.ForwardBackwardMaze(-1))
				g_cameraP1.ChangePosition(g_player1.dX, g_player1.dY);
			else
			{
				if (g_player1.posX == 7.5 && g_player1.posY == 8.5)
				{
					dirN1 = 180;
					dirS1 = 0;
					dirW1 = -90;
					dirE1 = 90;
				}
				else if (g_player1.posX == 7.5 && g_player1.posY == 10.5)
				{
					dirN1 = 0;
					dirS1 = 180;
					dirW1 = 90;
					dirE1 = -90;
				}
				else if (g_player1.posX == 6.5 && g_player1.posY == 9.5)
				{
					dirE1 = 180;
					dirW1 = 0;
					dirN1 = -90;
					dirS1 = 90;
				}
				else if (g_player1.posX == 8.5 && g_player1.posY == 9.5)
				{
					dirW1 = 180;
					dirE1 = 0;
					dirN1 = 90;
					dirS1 = -90;
				}
				g_cameraP1.PositionCamera(g_player1.posX + g_player1.dX, g_player1.posY + g_player1.dY, 0.9, g_player1.posX, g_player1.posY, 0.7, 0, 0, 1);
				g_grid.player1InMaze = false;
			}
			g_grid.Update(g_player1.posX, g_player1.posY, 1);
		}
	}

	if (GetKeyState('Z') & 0x80) 
	{
		if(!g_grid.player1InMaze && g_grid.HasNoObject(g_player1.posX, g_player1.posY) && g_player1.HasTraps())
			g_grid.SetTrap(g_player1.posX, g_player1.posY);
	}

	if (GetKeyState('X') & 0x80)
	{			
		if(!g_grid.player1InMaze && g_grid.HasNoObject(g_player1.posX, g_player1.posY) && g_player1.HasWalls())
			g_grid.SetWall(g_player1.posX, g_player1.posY);
	}

	if (GetKeyState('G') & 0x80) 
	{
		if (!g_grid.player1InMaze && (g_player1.outOfMazeTime < 0 || now - g_player1.outOfMazeTime > PAUSETIME))
		{
			g_cameraP1.RotateH(dirE1, g_player1.posX, g_player1.posY, 2.0);
			g_player1.Rotate(g_cameraP1.View() - g_cameraP1.Position(), g_cameraP1.Right());

			if (!g_player1.ForwardBackward())
			{
				dirN1 = 0;
				dirS1 = 180;
				dirW1 = 90;
				dirE1 = -90;
				
				if (g_player1.posX > 100)
				{
					g_cameraP1.PositionCamera(g_player1.posX + g_player1.dX, g_player1.posY + g_player1.dY, 0.9, g_player1.posX, g_player1.posY, 0.85, 0, 0, 1);
					g_grid.player1InMaze = true;
				}
				else
					g_cameraP1.PositionCamera(g_player1.posX + g_player1.dX, g_player1.posY + g_player1.dY, 0.9, g_player1.posX, g_player1.posY, 0.7, 0, 0, 1);
			}
			else
			{
				g_grid.Update(g_player1.posX, g_player1.posY, 1);
				g_cameraP1.ChangePosition(g_player1.dX, g_player1.dY);

				dirW1 = 180;
				dirE1 = 0;
				dirN1 = 90;
				dirS1 = -90;
			}
		}
		else if (g_grid.player1InMaze)
		{
			g_cameraP1.RotateH(-5.0, g_player1.posX, g_player1.posY, g_player1.radius + 0.5);
			g_player1.Rotate(g_cameraP1.View() - g_cameraP1.Position(), g_cameraP1.Right());
		}
	}

	if (GetKeyState('D') & 0x80)
	{
		if (!g_grid.player1InMaze && (g_player1.outOfMazeTime < 0 || now - g_player1.outOfMazeTime > PAUSETIME))
		{
			g_cameraP1.RotateH(dirW1, g_player1.posX, g_player1.posY, 2.0);
			g_player1.Rotate(g_cameraP1.View() - g_cameraP1.Position(), g_cameraP1.Right());

			if (!g_player1.ForwardBackward())
			{
				dirN1 = 0;
				dirS1 = 180;
				dirW1 = 90;
				dirE1 = -90;

				if (g_player1.posX > 100)
				{
					g_cameraP1.PositionCamera(g_player1.posX + g_player1.dX, g_player1.posY + g_player1.dY, 0.9, g_player1.posX, g_player1.posY, 0.7, 0, 0, 1);
					g_grid.player1InMaze = true;
				}
				else
					g_cameraP1.PositionCamera(g_player1.posX + g_player1.dX, g_player1.posY + g_player1.dY, 0.9, g_player1.posX, g_player1.posY, 0.7, 0, 0, 1);
			}
			else
			{
				g_grid.Update(g_player1.posX, g_player1.posY, 1);
				g_cameraP1.ChangePosition(g_player1.dX, g_player1.dY);

				dirE1 = 180;
				dirW1 = 0;
				dirN1 = -90;
				dirS1 = 90;
			}
		}
		else if (g_grid.player1InMaze)
		{
			g_cameraP1.RotateH(5.0, g_player1.posX, g_player1.posY, g_player1.radius + 0.5);
			g_player1.Rotate(g_cameraP1.View() - g_cameraP1.Position(), g_cameraP1.Right());
		}
	}

	if (GetKeyState(VK_LSHIFT) & 0x80)
	{			
		if (!g_grid.player1InMaze)
			g_player1.SetBomb();
	}

	if (GetKeyState(VK_UP) & 0x80) 
	{
		if (!g_grid.player2InMaze && (g_player2.outOfMazeTime < 0 || now - g_player2.outOfMazeTime > PAUSETIME))
		{
			g_cameraP2.RotateH(dirN2, g_player2.posX, g_player2.posY, 2.0);
			g_player2.Rotate(g_cameraP2.View() - g_cameraP2.Position(), g_cameraP2.Right());

			if (!g_player2.ForwardBackward())
			{
				dirN2 = 0;
				dirS2 = 180;
				dirW2 = 90;
				dirE2 = -90;
				if (g_player2.posX > 100)
				{
					g_cameraP2.PositionCamera(g_player2.posX + g_player2.dX, g_player2.posY + g_player2.dY, 0.9, g_player2.posX, g_player2.posY, 0.85, 0, 0, 1);
					g_grid.player2InMaze = true;
				}
				else
					g_cameraP2.PositionCamera(g_player2.posX + g_player2.dX, g_player2.posY + g_player2.dY, 0.9, g_player2.posX, g_player2.posY, 0.7, 0, 0, 1);

			}
			else
			{
				g_grid.Update(g_player2.posX, g_player2.posY, 2);
				g_cameraP2.ChangePosition(g_player2.dX, g_player2.dY);

				dirS2 = 180;
				dirN2 = 0;
				dirW2 = 90;
				dirE2 = -90;
			}
		}
		else if (g_grid.player2InMaze)
		{
			if (g_player2.ForwardBackwardMaze(1))
				g_cameraP2.ChangePosition(g_player2.dX, g_player2.dY);
			else
			{
				if (g_player2.posX == 7.5 && g_player2.posY == 8.5)
				{
					dirN2 = 180;
					dirS2 = 0;
					dirW2 = -90;
					dirE2 = 90;
				}
				else if (g_player2.posX == 7.5 && g_player2.posY == 10.5)
				{
					dirN2 = 0;
					dirS2 = 180;
					dirW2 = 90;
					dirE2 = -90;
				}
				else if (g_player2.posX == 6.5 && g_player2.posY == 9.5)
				{
					dirE2 = 180;
					dirW2 = 0;
					dirN2 = -90;
					dirS2 = 90;
				}
				else if (g_player2.posX == 8.5 && g_player2.posY == 9.5)
				{
					dirW2 = 180;
					dirE2 = 0;
					dirN2 = 90;
					dirS2 = -90;
				}
				g_cameraP2.PositionCamera(g_player2.posX + g_player2.dX, g_player2.posY + g_player2.dY, 0.9, g_player2.posX, g_player2.posY, 0.7, 0, 0, 1);
				g_grid.player2InMaze = false;
			}
			g_grid.Update(g_player2.posX, g_player2.posY, 2);
		}
	}

	if (GetKeyState(VK_DOWN) & 0x80) 
	{
		if (!g_grid.player2InMaze && (g_player2.outOfMazeTime < 0 || now - g_player2.outOfMazeTime > PAUSETIME))
		{
			g_cameraP2.RotateH(dirS2, g_player2.posX, g_player2.posY, 2.0);
			g_player2.Rotate(g_cameraP2.View() - g_cameraP2.Position(), g_cameraP2.Right());

			if (!g_player2.ForwardBackward())
			{
				dirN2 = 0;
				dirS2 = 180;
				dirW2 = 90;
				dirE2 = -90;
				if (g_player2.posX > 100)
				{
					g_cameraP2.PositionCamera(g_player2.posX + g_player2.dX, g_player2.posY + g_player2.dY, 0.9, g_player2.posX, g_player2.posY, 0.85, 0, 0, 1);
					g_grid.player2InMaze = true;
				}
				else
					g_cameraP2.PositionCamera(g_player2.posX + g_player2.dX, g_player2.posY + g_player2.dY, 0.9, g_player2.posX, g_player2.posY, 0.7, 0, 0, 1);
			}
			else
			{
				g_grid.Update(g_player2.posX, g_player2.posY, 2);
				g_cameraP2.ChangePosition(g_player2.dX, g_player2.dY);

				dirN2 = 180;
				dirS2 = 0;
				dirW2 = -90;
				dirE2 = 90;
			}
		}
		else if (g_grid.player2InMaze)
		{
			if (g_player2.ForwardBackwardMaze(-1))
				g_cameraP2.ChangePosition(g_player2.dX, g_player2.dY);
			else
			{
				if (g_player2.posX == 7.5 && g_player2.posY == 8.5)
				{
					dirN2 = 180;
					dirS2 = 0;
					dirW2 = -90;
					dirE2 = 90;
				}
				else if (g_player2.posX == 7.5 && g_player2.posY == 10.5)
				{
					dirN2 = 0;
					dirS2 = 180;
					dirW2 = 90;
					dirE2 = -90;
				}
				else if (g_player2.posX == 6.5 && g_player2.posY == 9.5)
				{
					dirE2 = 180;
					dirW2 = 0;
					dirN2 = -90;
					dirS2 = 90;
				}
				else if (g_player2.posX == 8.5 && g_player2.posY == 9.5)
				{
					dirW2 = 180;
					dirE2 = 0;
					dirN2 = 90;
					dirS2 = -90;
				}
				g_cameraP2.PositionCamera(g_player2.posX + g_player2.dX, g_player2.posY + g_player2.dY, 0.9, g_player2.posX, g_player2.posY, 0.7, 0, 0, 1);
				g_grid.player2InMaze = false;
			}
			g_grid.Update(g_player2.posX, g_player2.posY, 2);
		}
	}

	if (GetKeyState(VK_SLASH) & 0x80)
	{
		if(!g_grid.player2InMaze && g_grid.HasNoObject(g_player2.posX, g_player2.posY) && g_player2.HasTraps())
			g_grid.SetTrap(g_player2.posX, g_player2.posY);
	}

	if (GetKeyState(VK_PERIOD) & 0x80)
	{
		if(!g_grid.player2InMaze && g_grid.HasNoObject(g_player2.posX, g_player2.posY) && g_player2.HasWalls())
			g_grid.SetWall(g_player2.posX, g_player2.posY);
	}

	if (GetKeyState(VK_RIGHT) & 0x80) 
	{
		if (!g_grid.player2InMaze && (g_player2.outOfMazeTime < 0 || now - g_player2.outOfMazeTime > PAUSETIME))
		{
			g_cameraP2.RotateH(dirE2, g_player2.posX, g_player2.posY, 2.0);
			g_player2.Rotate(g_cameraP2.View() - g_cameraP2.Position(), g_cameraP2.Right());

			if (!g_player2.ForwardBackward())
			{
				dirN2 = 0;
				dirS2 = 180;
				dirW2 = 90;
				dirE2 = -90;
				if (g_player2.posX > 100)
				{
					g_cameraP2.PositionCamera(g_player2.posX + g_player2.dX, g_player2.posY + g_player2.dY, 0.9, g_player2.posX, g_player2.posY, 0.85, 0, 0, 1);
					g_grid.player2InMaze = true;
				}
				else
					g_cameraP2.PositionCamera(g_player2.posX + g_player2.dX, g_player2.posY + g_player2.dY, 0.9, g_player2.posX, g_player2.posY, 0.7, 0, 0, 1);

			}
			else
			{
				g_grid.Update(g_player2.posX, g_player2.posY, 2);
				g_cameraP2.ChangePosition(g_player2.dX, g_player2.dY);

				dirW2 = 180;
				dirE2 = 0;
				dirN2 = 90;
				dirS2 = -90;
			}
		}
		else if (g_grid.player2InMaze)
		{
			g_cameraP2.RotateH(-5.0, g_player2.posX, g_player2.posY, g_player2.radius + 0.5);
			g_player2.Rotate(g_cameraP2.View() - g_cameraP2.Position(), g_cameraP2.Right());	
		}
	}

	if (GetKeyState(VK_LEFT) & 0x80)
	{
		if (!g_grid.player2InMaze && (g_player2.outOfMazeTime < 0 || now - g_player2.outOfMazeTime > PAUSETIME))
		{
			g_cameraP2.RotateH(dirW2, g_player2.posX, g_player2.posY, 2.0);
			g_player2.Rotate(g_cameraP2.View() - g_cameraP2.Position(), g_cameraP2.Right());

			if (!g_player2.ForwardBackward())
			{
				dirN2 = 0;
				dirS2 = 180;
				dirW2 = 90;
				dirE2 = -90;
				if (g_player2.posX > 100)
				{
					g_cameraP2.PositionCamera(g_player2.posX + g_player2.dX, g_player2.posY + g_player2.dY, 0.9, g_player2.posX, g_player2.posY, 0.85, 0, 0, 1);
					g_grid.player2InMaze = true;
				}
				else
					g_cameraP2.PositionCamera(g_player2.posX + g_player2.dX, g_player2.posY + g_player2.dY, 0.9, g_player2.posX, g_player2.posY, 0.7, 0, 0, 1);
			}
			else
			{
				g_grid.Update(g_player2.posX, g_player2.posY, 2);
				g_cameraP2.ChangePosition(g_player2.dX, g_player2.dY);

				dirE2 = 180;
				dirW2 = 0;
				dirN2 = -90;
				dirS2 = 90;
			}
		}
		else if (g_grid.player2InMaze)
		{
			g_cameraP2.RotateH(5.0, g_player2.posX, g_player2.posY, g_player2.radius + 0.5);
			g_player2.Rotate(g_cameraP2.View() - g_cameraP2.Position(), g_cameraP2.Right());	
		}
	}

	if (GetKeyState(VK_RSHIFT) & 0x80)
	{			
		if (!g_grid.player2InMaze)
			g_player2.SetBomb();
	}
	
	if (GetKeyState('0') & 0x80)
	{			
		shadow = !shadow;
	}
}


void ChangeToFullScreen()
{
	DEVMODE dmSettings;									// Device Mode variable

	memset(&dmSettings,0,sizeof(dmSettings));			// Makes Sure Memory's Cleared

	// Get current settings -- This function fills our the settings
	// This makes sure NT and Win98 machines change correctly
	if(!EnumDisplaySettings(NULL,ENUM_CURRENT_SETTINGS,&dmSettings))
	{
		// Display error message if we couldn't get display settings
		MessageBox(NULL, "Could Not Enum Display Settings", "Error", MB_OK);
		return;
	}

	dmSettings.dmPelsWidth	= SCREEN_WIDTH;				// Selected Screen Width
	dmSettings.dmPelsHeight	= SCREEN_HEIGHT;			// Selected Screen Height
	
	// This function actually changes the screen to full screen
	// CDS_FULLSCREEN Gets Rid Of Start Bar.
	// We always want to get a result from this function to check if we failed
	int result = ChangeDisplaySettings(&dmSettings,CDS_FULLSCREEN);	

	// Check if we didn't recieved a good return message From the function
	if(result != DISP_CHANGE_SUCCESSFUL)
	{
		// Display the error message and quit the program
		MessageBox(NULL, "Display Mode Not Compatible", "Error", MB_OK);
		PostQuitMessage(0);
	}
}


HWND CreateMyWindow(LPSTR strWindowName, int width, int height, DWORD dwStyle, bool bFullScreen, HINSTANCE hInstance)
{
	HWND hWnd;
	WNDCLASS wndclass;
	
	memset(&wndclass, 0, sizeof(WNDCLASS));				// Init the size of the class
	wndclass.style = CS_HREDRAW | CS_VREDRAW;			// Regular drawing capabilities
	wndclass.lpfnWndProc = WinProc;						// Pass our function pointer as the window procedure
	wndclass.hInstance = hInstance;						// Assign our hInstance
	wndclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);	// General icon
	wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);		// An arrow for the cursor
	wndclass.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);	// A white window
	wndclass.lpszClassName = "HAMS!!";			// Assign the class name

	RegisterClass(&wndclass);							// Register the class
	
	if(bFullScreen && !dwStyle) 						// Check if we wanted full screen mode
	{													// Set the window properties for full screen mode
		dwStyle = WS_POPUP | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;
		ChangeToFullScreen();							// Go to full screen
		ShowCursor(FALSE);								// Hide the cursor
	}
	else if(!dwStyle)									// Assign styles to the window depending on the choice
		dwStyle = WS_OVERLAPPEDWINDOW | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;
	
	g_hInstance = hInstance;							// Assign our global hInstance to the window's hInstance

	RECT rWindow;
	rWindow.left	= 0;								// Set Left Value To 0
	rWindow.right	= width;							// Set Right Value To Requested Width
	rWindow.top	    = 0;								// Set Top Value To 0
	rWindow.bottom	= height;							// Set Bottom Value To Requested Height

	AdjustWindowRect( &rWindow, dwStyle, false);		// Adjust Window To True Requested Size

														// Create the window
	hWnd = CreateWindow("HAMS!!", strWindowName, dwStyle, 0, 0,
						rWindow.right  - rWindow.left, rWindow.bottom - rWindow.top, 
						NULL, NULL, hInstance, NULL);

	if(!hWnd) return NULL;								// If we could get a handle, return NULL

	ShowWindow(hWnd, SW_SHOWNORMAL);					// Show the window
	UpdateWindow(hWnd);									// Draw the window

	SetFocus(hWnd);										// Sets Keyboard Focus To The Window	

	return hWnd;
}


bool bSetupPixelFormat(HDC hdc) 
{ 
    PIXELFORMATDESCRIPTOR pfd; 
    int pixelformat; 
 
    pfd.nSize = sizeof(PIXELFORMATDESCRIPTOR);			// Set the size of the structure
    pfd.nVersion = 1;									// Always set this to 1
														// Pass in the appropriate OpenGL flags
    pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER; 
    pfd.dwLayerMask = PFD_MAIN_PLANE;					// We want the standard mask (this is ignored anyway)
    pfd.iPixelType = PFD_TYPE_RGBA;						// We want RGB and Alpha pixel type
    pfd.cColorBits = SCREEN_DEPTH;						// Here we use our #define for the color bits
    pfd.cDepthBits = SCREEN_DEPTH;						// Depthbits is ignored for RGBA, but we do it anyway
    pfd.cAccumBits = 0;									// No special bitplanes needed
    pfd.cStencilBits = 0;								// We desire no stencil bits
 
	// This gets us a pixel format that best matches the one passed in from the device
    if ( (pixelformat = ChoosePixelFormat(hdc, &pfd)) == FALSE ) 
    { 
        MessageBox(NULL, "ChoosePixelFormat failed", "Error", MB_OK); 
        return FALSE; 
    } 
 
	// This sets the pixel format that we extracted from above
    if (SetPixelFormat(hdc, pixelformat, &pfd) == FALSE) 
    { 
        MessageBox(NULL, "SetPixelFormat failed", "Error", MB_OK); 
        return FALSE; 
    } 
 
    return TRUE;										// Return a success!
}

void SizeOpenGLScreen(int width, int height)			// Initialize The GL Window
{
	if (height==0)										// Prevent A Divide By Zero error
	{
		height=1;										// Make the Height Equal One
	}

	glViewport(0,0,width,height);						// Make our viewport the whole window
														// We could make the view smaller inside
														// Our window if we wanted too.
														// The glViewport takes (x, y, width, height)
														// This basically means, what our our drawing boundries

	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glLoadIdentity();									// Reset The Projection Matrix

														// Calculate The Aspect Ratio Of The Window
														// The parameters are:
														// (view angle, aspect ration of the width to the height, 
														//  The closest distance to the camera before it clips, 
				  // FOV		// Ratio				//  The farthest distance before it stops drawing)
	gluPerspective(45.0f, (GLfloat)width/(GLfloat)height, 0.5, 150.0f);

	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glLoadIdentity();									// Reset The Modelview Matrix
}




void DeInit()
{
	if (g_hRC)											
	{
		wglMakeCurrent(NULL, NULL);						// This frees our rendering memory and sets everything back to normal
		wglDeleteContext(g_hRC);						// Delete our OpenGL Rendering Context	
	}
	
	if (g_hDC) 
		ReleaseDC(g_hWnd, g_hDC);						// Release our HDC from memory
		
	if(g_bFullScreen)									// If we were in full screen
	{
		ChangeDisplaySettings(NULL,0);					// If So Switch Back To The Desktop
		ShowCursor(TRUE);								// Show Mouse Pointer
	}

	UnregisterClass("HAMS!!", g_hInstance);		// Free the window class

	PostQuitMessage (0);								// Post a QUIT message to the window
}



int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hprev, PSTR cmdline, int ishow)
{	
	HWND hWnd;

	// Set the full screen option to false since you can't view the FPS in full screen.
	g_bFullScreen = false;
	
	// Create our window with our function we create that passes in the:
	// Name, width, height, any flags for the window, if we want fullscreen of not, and the hInstance
	hWnd = CreateMyWindow("HAMS!!", SCREEN_WIDTH, SCREEN_HEIGHT, 0, g_bFullScreen, hInstance);

	// If we never got a valid window handle, quit the program
	if(hWnd == NULL) return TRUE;

	// INIT OpenGL
	Init(hWnd);													

	// Run our message loop and after it's done, return the result
	return MainLoop();						
}

void Init(HWND hWnd)
{
	g_hWnd = hWnd;										// Assign the window handle to a global window handle
	GetClientRect(g_hWnd, &g_rRect);					// Assign the windows rectangle to a global RECT
	InitializeOpenGL(g_rRect.right, g_rRect.bottom);	// Init OpenGL with the global rect
	InitializeObjects();
}


LRESULT CALLBACK WinProc(HWND hWnd,UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    LONG    lRet = 0; 
    PAINTSTRUCT    ps;

    switch (uMsg)
	{ 
    case WM_SIZE:										// If the window is resized
		if(!g_bFullScreen)								// Do this only if we are NOT in full screen
		{
			SizeOpenGLScreen(LOWORD(lParam),HIWORD(lParam));// LoWord=Width, HiWord=Height
			GetClientRect(hWnd, &g_rRect);					// Get the window rectangle
		}
        break; 
 
	case WM_PAINT:										// If we need to repaint the scene
		BeginPaint(hWnd, &ps);							// Init the paint struct		
		EndPaint(hWnd, &ps);							// EndPaint, Clean up
		break;

	case WM_KEYDOWN:
		if(wParam == VK_ESCAPE)	DeInit();				// Quit if we pressed ESCAPE
		break;
 
    case WM_DESTROY:									// If the window is destroyed
        DeInit();										// Release memory and restore settings
        break; 
     
    default:											// Return by default
        lRet = DefWindowProc (hWnd, uMsg, wParam, lParam); 
        break; 
    } 
 
    return lRet;										// Return by default
}