#include <stdio.h>
#include <GL/glut.h>

#include <vector>
#define vector std::vector

#include "WorkingScene.h"

WorkingScene scene;

void display() {	
	//First, the ModelViewProjection Matrix is setup
	//this determines how the scene will be viewed
	float m[] = {	2.0, 0, 0, 0,
					0, 2.0, 0, 0,
					0, 0, 2.0, 0,
					-1.0, -1.0, 0, 1.0};
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glMultMatrixf(m);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	//Second, the framebuffer is filled with the objects in the scene
	glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	if (scene.theOnlyCurve != NULL) {
		scene.theOnlyCurve->draw(scene.levelOfDetail);
	}
	glutSwapBuffers();
}


//This program has memory leaks, but we won't worry about that right now
int main(int argc, char* argv[]) {
	
	argc = 1;
	glutInit( &argc, argv );
	glutInitWindowPosition( 100, 100 );
	scene.width = 400;
	glutInitWindowSize( scene.width, scene.height );
	glutInitDisplayMode( GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH );

	glutCreateWindow( "Drawing Curves is fun..." );
	glutDisplayFunc( display );
	glutKeyboardFunc( scene.keyboard );
	glutMouseFunc( scene.mouse );
	glutReshapeFunc( scene.reshape );
	glutPassiveMotionFunc( scene.passiveMotion );
	glutMotionFunc( scene.drag );
	
	glutMainLoop();
	return 0;
}
