#include "Scene.h"
#include "Bezier.h"
#include "Bspline.h"
#include "Bezier2.h"

int Scene::height = 400;
int Scene::width = 400;
int Scene::oldx = 0;
int Scene::oldy = 0;
int Scene::levelOfDetail = 5;

Curve * Scene::theOnlyCurve = NULL;

void Scene::keyboard( unsigned char key, int x, int y )
{
	switch(key) {
	case '0':
		if (theOnlyCurve != NULL) delete theOnlyCurve;
		theOnlyCurve = new Curve();
		printf("Straight Line.\n");
		break;
	case '1':
		if (theOnlyCurve != NULL) delete theOnlyCurve;
		theOnlyCurve = new Bezier();
		printf("Bezier Curve.\n");
		break;
	case '2':
		if (theOnlyCurve != NULL) delete theOnlyCurve;
		theOnlyCurve = new Bspline();
		printf("Bspline Curve.\n");
		break;
	case '3':
		if (theOnlyCurve != NULL) delete theOnlyCurve;
		theOnlyCurve = new Bezier2();
		printf("Bezier 2 Curve.\n");
		break;
	case '+':
		levelOfDetail++;
		break;
	case '-':
		levelOfDetail--;
		break;
	}
	if (levelOfDetail < 1) {
		levelOfDetail = 1;
	}
	printf("Level of Detail: %d.\n", levelOfDetail);
	glutPostRedisplay();
}

void Scene::reshape(int w, int h) {
	width = w;
	height = h;
	glViewport( 0,0, w, h );
	glutPostRedisplay();
}


void Scene::drag(int x, int y) {}

void Scene::passiveMotion(int x, int y) {
	if (theOnlyCurve != NULL) {
		theOnlyCurve->updateActivePoint(x / (float)width, (height-y) / (float)height); 
	}
	glutPostRedisplay();
}

void Scene::mouse(int button, int state, int x, int y) {}

Scene::Scene() {
	height = 400;
	width = 800;
	theOnlyCurve = NULL;
}

Scene::~Scene() {

}
