#include "Curve.h"

void Curve::connectTheDots() {
	Pvector::iterator it, next;
	if (points.size() > 1) {
		for (it = points.begin(); it != points.end()-1; it++) {
			next = it+1;
			//drawLine(it->x, it->y, next->x, next->y);
			//drawLine doesn't take a color, so it's recreated here.
			glColor3f(0, 1, 0);
			glBegin( GL_LINES );
				glVertex2f(it->x, it->y);
				glVertex2f(next->x, next->y);
			glEnd();
		}
	}
	for (it = points.begin(); it != points.end(); it++) {
		it->draw();
	}
}


void Curve::draw(int lod) {
	if (!points.empty()) {
		connectTheDots();
	}
}

void Curve::addPoint(float x, float y) {
	if (activePoint == NULL) {
		points.push_back(Point(x, y));
	}
}

void Curve::deleteActivePoint() {
	if (activePoint != NULL) {
		points.erase(activePoint);
		activePoint = NULL;
	}
}

void Curve::moveActivePoint(float dx, float dy) {
	if (activePoint != NULL) {
		activePoint->x += dx;
		activePoint->y += dy;
	}
}

void Curve::updateActivePoint(float x, float y) {
	float dx, dy, dist2;
	float radius = Point::ACTIVE_RADIUS*Point::ACTIVE_RADIUS;
	dist2 = 1;
	if (activePoint != NULL) {
		dx = activePoint->x - x;
		dy = activePoint->y - y;
		dist2 = dx*dx + dy*dy;
	}
	if (dist2 > radius) {
		if (activePoint != NULL) activePoint->active = false;
		activePoint = NULL;
		for (Pvector::iterator it = points.begin(); it != points.end(); it++) {
			dx = it->x - x;
			dy = it->y - y;
			dist2 = dx*dx + dy*dy;
			if (dist2 < radius) {
				activePoint = it;
				it->active = true;
				break;
			}
		}
	}
}

void Curve::drawLine(float x1, float y1, float x2, float y2) {
	glColor3f(0,0,1);
	glBegin( GL_LINES );
		glVertex2f( x1, y1 );
		glVertex2f( x2, y2 );
	glEnd();
}

Curve::Curve()
{
	activePoint = NULL;
}

Curve::~Curve()
{

}
