

#include <stdio.h>
#include <gl/glut.h>

#include "Transform.h"

int amount;

vec3 eye;
vec3 up;
bool useGlu, updateLight0, updateLight1;
int w, h;

void printBool(char* str, bool b) {
	if (b) {
		printf(str, "true");
	} else {
		printf(str, "false");
	}
}

void printHelp() {
	printf("\npress 'h' to print this message again.\n");
	printf("press '+' or '-' to change the amount of rotation that\noccurs with each arrow press.\n");
	printf("press 'g' to switch between using gluLookAt or LookAt.\n");
	printf("press '0' to switch between updating or not updating Light0's position\nwhen the view is updated.\n");
	printf("press '1' to switch between updating or not updating Light1's position\nwhen the view is updated.\n\n");
}

void keyboard(unsigned char key, int x, int y) {
	switch(key) {
	case '+':
		amount++;
		printf("amount set to %d\n", amount);
		break;
	case '-':
		amount--;
		printf("amount set to %d\n", amount);
		break;
	case 'g':
		useGlu = !useGlu;
		printBool("Using gluLookAt set to: %s.\n", useGlu);
		break;
	case 'h':
		printHelp();
		break;
	case '0':
		updateLight0 = !updateLight0;
		printBool("Update Light 0 set to: %s.\n", updateLight0);
		break;
	case '1':
		updateLight1 = !updateLight1;
		printBool("Update Light 1 set to: %s. \n", updateLight1);
		break;
	}
	glutPostRedisplay();
}

void specialKey(int key, int x, int y) {
	switch(key) {
	case 100: //left
		Transform::left(amount, eye,  up);
		break;
	case 101: //up
		Transform::up(amount,  eye,  up);
		break;
	case 102: //right
		Transform::left(-amount,  eye,  up);
		break;
	case 103: //down
		Transform::up(-amount,  eye,  up);
		break;
	}
	up.normalize();
	glutPostRedisplay();
}

void reshape(int width, int height){
	w = width;
	h = height;
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(90, w/(float)h, 0.1, 99);
	glViewport(0, 0, w, h);
}

void setLightPosition0() {
	GLfloat light_position[] = {0, 5, 10, 1};
	glLightfv(GL_LIGHT0, GL_POSITION, light_position);

}

void setLightPosition1() {
	GLfloat light_position[] = {0, 5, -10, 1};
	glLightfv(GL_LIGHT1, GL_POSITION, light_position);
}

void init() {
	eye = vec3(0, 0, 5);
	up = vec3(0, 1, 0);
	amount = 5;
	useGlu = true;
	updateLight0 = false;
	updateLight1 = false;

	//set up a point light
	glEnable(GL_LIGHTING);
	GLfloat light_specular[] = {1, 0.5, 0, 1};
	glLightfv(GL_LIGHT0, GL_SPECULAR, light_specular);
	glEnable(GL_LIGHT0);

	//set up another point light
	GLfloat light_specular1[] = {0, 0.5, 1, 1};
	glLightfv(GL_LIGHT1, GL_SPECULAR, light_specular1);
	glEnable(GL_LIGHT1);

	//this usually goes right before glBegin(), but we'll put it here since it never changes
	GLfloat one[] = {1, 1, 1, 1};
	GLfloat small[] = {0.2, 0.2, 0.2, 1};
	GLfloat high[] = {100};
	glMaterialfv(GL_FRONT, GL_AMBIENT, one);
	glMaterialfv(GL_FRONT, GL_SPECULAR, one);
	glMaterialfv(GL_FRONT, GL_DIFFUSE, small);
	glMaterialfv(GL_FRONT, GL_SHININESS, high);

	//set initial lighting positions
	setLightPosition0();
	setLightPosition1();

	glEnable(GL_DEPTH_TEST);
}

void display() {
	glClearColor(0, 0, 1, 0);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);


	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	if (useGlu) {
		gluLookAt(eye.x, eye.y, eye.z,
			0, 0, 0,
			up.x, up.y, up.z);
	} else {
		mat4 mv = Transform::lookAt(eye, up);
		glMultMatrixf(mv.mat_array);
	}

	if (updateLight0) {
		setLightPosition0();
	}
	if (updateLight1) {
		setLightPosition1();
	}
	glutSolidTeapot(2);

	glutSwapBuffers();
}

int main(int argc, char* argv[]) {
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA | GLUT_DEPTH);
	glutCreateWindow("HW1: Transformations");
	init();
	glutDisplayFunc(display);
	glutSpecialFunc(specialKey);
	glutKeyboardFunc(keyboard);
	glutReshapeFunc(reshape);
	glutReshapeWindow(600, 400);
	printHelp();
	glutMainLoop();
	return 0;
}