/*
 * Decompiled with CFR 0.152.
 */
package graph;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

class RotateTextFilter
extends ImageFilter {
    private int angle;
    private int xmin;
    private int xmax;
    private int ymin;
    private int ymax;
    private int width;
    private int height;
    private double cos = 1.0;
    private double sin;
    private int[] ipixels;
    private byte[] bpixels;
    private ColorModel colorModel;

    public RotateTextFilter(int n) {
        this.angle = n % 360 / 90 * 90;
        this.cos = Math.cos((double)n * Math.PI / 180.0);
        this.sin = Math.sin((double)n * Math.PI / 180.0);
    }

    public void setProperties(Hashtable hashtable) {
        hashtable = (Hashtable)hashtable.clone();
        hashtable.put("rotAngle", new Integer(this.angle));
        super.setProperties(hashtable);
    }

    public void setDimensions(int n, int n2) {
        int[] nArray = new int[]{0, n - 1, n - 1, 0};
        int[] nArray2 = new int[]{0, 0, n2 - 1, n2 - 1};
        int n3 = 0;
        while (n3 < 4) {
            int n4 = (int)Math.round((double)nArray[n3] * this.cos + (double)nArray2[n3] * this.sin);
            int n5 = (int)Math.round((double)(-nArray[n3]) * this.sin + (double)nArray2[n3] * this.cos);
            this.xmin = Math.min(this.xmin, n4);
            this.xmax = Math.max(this.xmax, n4);
            this.ymin = Math.min(this.ymin, n5);
            this.ymax = Math.max(this.ymax, n5);
            ++n3;
        }
        this.width = this.xmax - this.xmin + 1;
        this.height = this.ymax - this.ymin + 1;
        this.consumer.setDimensions(this.width, this.height);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (this.bpixels == null) {
            this.colorModel = colorModel;
            this.bpixels = new byte[this.width * this.height];
        }
        int n7 = n2;
        int n8 = 0;
        while (n8 < n4) {
            int n9 = n;
            int n10 = 0;
            while (n10 < n3) {
                int n11 = (int)Math.round((double)n9 * this.cos + (double)n7 * this.sin) - this.xmin;
                int n12 = (int)Math.round((double)(-n9) * this.sin + (double)n7 * this.cos) - this.ymin;
                int n13 = n11 + n12 * this.width;
                this.bpixels[n13] = byArray[(n7 - n2) * n6 + (n9 - n) + n5];
                ++n10;
                ++n9;
            }
            ++n8;
            ++n7;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (this.ipixels == null) {
            this.colorModel = colorModel;
            this.ipixels = new int[this.width * this.height];
        }
        int n7 = n2;
        int n8 = 0;
        while (n8 < n4) {
            int n9 = n;
            int n10 = 0;
            while (n10 < n3) {
                int n11 = (int)Math.round((double)n9 * this.cos + (double)n7 * this.sin) - this.xmin;
                int n12 = (int)Math.round((double)(-n9) * this.sin + (double)n7 * this.cos) - this.ymin;
                int n13 = n11 + n12 * this.width;
                this.ipixels[n13] = nArray[(n7 - n2) * n6 + (n9 - n) + n5];
                ++n10;
                ++n9;
            }
            ++n8;
            ++n7;
        }
    }

    public void imageComplete(int n) {
        if (n == 4 || n == 1) {
            this.consumer.imageComplete(n);
            this.ipixels = null;
            this.bpixels = null;
            return;
        }
        if (this.bpixels != null) {
            int n2 = 0;
            while (n2 < this.height) {
                this.consumer.setPixels(0, n2, this.width, 1, this.colorModel, this.bpixels, n2 * this.width, this.width);
                ++n2;
            }
            this.consumer.imageComplete(n);
        } else if (this.ipixels != null) {
            int n3 = 0;
            while (n3 < this.height) {
                this.consumer.setPixels(0, n3, this.width, 1, this.colorModel, this.ipixels, n3 * this.width, this.width);
                ++n3;
            }
            this.consumer.imageComplete(n);
        } else {
            this.consumer.imageComplete(4);
        }
        this.ipixels = null;
        this.bpixels = null;
    }
}

