/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.DataSet;
import graph.Graph2D;
import java.applet.Applet;
import java.io.InputStream;
import java.net.URL;

public class LoadData
extends Thread {
    public final int NUMERIC = 1;
    public final int OBJECT = 2;
    private Graph2D graph;
    private Applet applet;
    private URL file;
    private int Max = 250;
    private DataSet ds;
    private double[] array;
    private boolean finished = false;
    private boolean started = false;
    private int count;
    private int dataType = 1;

    public LoadData() {
        this.finished = false;
        this.started = false;
    }

    public LoadData(DataSet dataSet) {
        this.ds = dataSet;
        this.finished = false;
        this.started = false;
    }

    public DataSet loadDataSet(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (this.ds == null) {
            this.ds = new DataSet();
        }
        this.file = uRL;
        this.start();
        return this.ds;
    }

    public void loadArray(URL uRL) {
        if (uRL == null) {
            return;
        }
        this.file = uRL;
        this.start();
    }

    public DataSet loadDataSet(URL uRL, Object object) {
        if (uRL == null) {
            return null;
        }
        if (this.ds == null) {
            this.ds = new DataSet();
        }
        this.file = uRL;
        if (object != null) {
            if (object instanceof Applet) {
                this.applet = (Applet)object;
            } else if (object instanceof Graph2D) {
                this.graph = (Graph2D)object;
                this.graph.attachDataSet(this.ds);
            }
        }
        this.start();
        return this.ds;
    }

    public void loadArray(URL uRL, Object object) {
        if (uRL == null) {
            return;
        }
        this.file = uRL;
        if (object != null) {
            if (object instanceof Applet) {
                this.applet = (Applet)object;
            } else if (object instanceof Graph2D) {
                this.graph = (Graph2D)object;
                this.graph.attachDataSet(this.ds);
            }
        }
        this.start();
    }

    public void run() {
        int n = 2 * this.Max;
        byte[] byArray = new byte[50];
        int n2 = 0;
        double[] dArray = new double[n];
        int n3 = 0;
        InputStream inputStream = null;
        boolean bl = false;
        this.setPriority(1);
        try {
            int n4;
            inputStream = this.file.openStream();
            this.started = true;
            this.count = 0;
            if (this.graph != null) {
                this.graph.startedloading();
            }
            block7: while ((n4 = inputStream.read()) > -1) {
                switch (n4) {
                    case 35: {
                        bl = true;
                        break;
                    }
                    case 10: 
                    case 13: {
                        bl = false;
                    }
                    case 9: 
                    case 32: {
                        if (n2 <= 0) continue block7;
                        String string = new String(byArray, 0, 0, n2);
                        dArray[n3] = Double.valueOf(string);
                        if (++n3 >= n) {
                            this.append(dArray, n3);
                            n3 = 0;
                            System.out.println("Loading Data! Points Loaded " + this.count);
                        }
                        n2 = 0;
                        break;
                    }
                    default: {
                        if (bl) continue block7;
                        byArray[n2] = (byte)n4;
                        ++n2;
                        break;
                    }
                }
            }
            if (n3 > 1) {
                this.append(dArray, n3);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            this.printmessage("Error loading data!");
            return;
        }
        this.started = false;
        this.finished = true;
        if (this.graph != null) {
            this.graph.finishedloading();
        }
        if (this.count == 0) {
            this.printmessage("Zero data loaded!");
            return;
        }
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    public synchronized double[] getArray() {
        if (this.array == null || this.array.length == 0) {
            return null;
        }
        if (this.finished) {
            return this.array;
        }
        if (this.started) {
            double[] dArray = new double[this.array.length];
            System.arraycopy(this.array, 0, dArray, 0, this.array.length);
            return dArray;
        }
        return null;
    }

    public boolean started() {
        return this.started;
    }

    public boolean finished() {
        return this.finished;
    }

    public int length() {
        return this.count;
    }

    private synchronized void append(double[] dArray, int n) {
        if (n == 0) {
            return;
        }
        this.count += n;
        if (this.ds != null) {
            try {
                this.ds.append(dArray, n / 2);
                return;
            }
            catch (Exception exception) {
                this.printmessage("Failed to append data to DataSet!");
                return;
            }
        }
        if (this.array != null) {
            double[] dArray2 = new double[this.array.length + n];
            System.arraycopy(this.array, 0, dArray2, 0, n);
            System.arraycopy(dArray, 0, dArray2, this.array.length, n);
            this.array = dArray2;
            return;
        }
        this.array = new double[n];
        System.arraycopy(dArray, 0, this.array, 0, n);
    }

    private void printmessage(String string) {
        if (string == null) {
            return;
        }
        if (this.applet != null) {
            this.applet.showStatus(string);
        }
        System.out.println(string);
    }
}

