/*
 * Decompiled with CFR 0.152.
 */
package graph;

public class Function {
    public static double log10(double d) throws ArithmeticException {
        return Math.log(d) / Math.E;
    }

    public static double cosh(double d) throws ArithmeticException {
        double d2 = Math.pow(Math.E, d);
        return 0.5 * (d2 + 1.0 / d2);
    }

    public static double sinh(double d) throws ArithmeticException {
        double d2 = Math.pow(Math.E, d);
        return 0.5 * (d2 - 1.0 / d2);
    }

    public static double tanh(double d) throws ArithmeticException {
        double d2 = Math.pow(Math.E, d);
        return (d2 - 1.0 / d2) / (d2 + 1.0 / d2);
    }

    public static double acosh(double d) throws ArithmeticException {
        if (d < 1.0) {
            throw new ArithmeticException("range exception");
        }
        return Math.log(d + Math.sqrt(d * d - 1.0));
    }

    public static double asinh(double d) throws ArithmeticException {
        return Math.log(d + Math.sqrt(d * d + 1.0));
    }

    public static double atanh(double d) throws ArithmeticException {
        if (d > 1.0 || d < -1.0) {
            throw new ArithmeticException("range exception");
        }
        return 0.5 * Math.log((1.0 + d) / (1.0 - d));
    }
}

