/*
 * Revision Control Information
 *
 * $Source$
 * $Author$
 * $Revision$
 * $Date$
 *
 */
#include "reductio.h"

prime(genclass,subclass)
int genclass,subclass;

{
   /*  prime = 1 iff the class(genclass,subclass) is c-prime */


   /*  Concept of prime class as established by Luccio et al. 
       ======================================================

       Definition : class Cj is escluded by class Ci iff
       1) Cj is strictly contained in Ci
       2) and Pi ( classes generated by Ci ) is contained 
          (also not strictly) in Pj ( classes generated by Cj ) -

       A class is prime ( definition ) iff it is not escluded by any other 
       compatibility class -

       Primality needs to be tested only on the maximal compatibles 
       and the other prime classes ( transitivity's sake )
   

       Concept of c-prime class ( implemented in Pinima )
       ==================================================

       Definition : class Cj is escluded by class Ci iff
       1) Cj is strictly contained in Ci
       2) and Pi (implied chain without header) is contained 
          (also not strictly) in Pj (implied chain without header) -
    
       A c-prime is also prime , but not viceversa , i.e.
       c-prime classes are a subset of prime classes -

       Unfortunately , in the current implementation , since we
       don't generate all maximal compatibles and c-prime classes
       ( to cut down the computation time we start from only one
         covering set of maximal compatibles and at each refinement
         step we generate only the c-primes thet can be obtained from
         the previous c-prime generation )
       a class can be accepted as c-prime although it is neither prime
       nor c-prime ( the dominating class has not been generated )      */

   /*  esclusa = 0 iff the j-subclass of the i-th class is c-prime ,
       i.e. is not escluded by any other (known)  c-prime class */

   int i;
   int esclusa,notesclusa;

   /*printf("*** PRIME OF %d %d\n", genclass,subclass);*/

   i = 0;
   esclusa = 0;
   while ( i < primes->count && esclusa == 0 )
   {
     if ( cl_inclus(genclass,subclass,i)==1 && 
              ch_inclus(i,genclass,subclass)==1 ) 
       esclusa = 1;
     i++;
   }

   /* notesclusa means c-prime */
   if (esclusa == 1) notesclusa = 0; else notesclusa = 1;
/*printf("prime = %d\n", notesclusa);*/
   return(notesclusa);

}
